package ar.com.sdd.mercadopago.entity.account;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class MercadoPagoReportConfigurationFrequency {

    private Integer hour;
    private String type;

    /*
    No ponemos value porque a veces viene como entero y a veces como objeto
    La documentacion es confusa y esto no se esta usando
     */
    //private Integer value;

    public Integer getHour() {
        return hour;
    }

    public void setHour(Integer hour) {
        this.hour = hour;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String toString() {
        return "ReportConfigurationFrequency ["
                + ((hour != null) ? "hour=" + hour + ", " : "")
                + ((type != null) ? "type=" + type + ", " : "")
                + "]";
    }
}
