package ar.com.sdd.mercadopago.entity.preference;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

/**
 * Mercado Pago SDK
 * Back URLs class
 * <p>
 * Created by Eduardo Paoletta on 11/9/16.
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class BackUrls {

    private String success = null;
    private String pending = null;
    private String failure = null;

    public BackUrls() {
    }

    public BackUrls(String successUrl, String pendingUrl, String failureUrl) {
        this.success = successUrl;
        this.pending = pendingUrl;
        this.failure = failureUrl;
    }


    public String getSuccess() {
        return success;
    }

    public BackUrls setSuccess(String success) {
        this.success = success;
        return this;
    }

    public String getPending() {
        return pending;
    }

    public BackUrls setPending(String pending) {
        this.pending = pending;
        return this;
    }

    public String getFailure() {
        return failure;
    }

    public BackUrls setFailure(String failure) {
        this.failure = failure;
        return this;
    }

    @Override
    public String toString() {
        return "BackUrls ["
                + ((success != null) ? "success=" + success + ", " : "")
                + ((pending != null) ? "pending=" + pending + ", " : "")
                + ((failure != null) ? "failure=" + failure : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        BackUrls backUrls = (BackUrls) o;

        if (success != null ? !success.equals(backUrls.success) : backUrls.success != null) return false;
        if (pending != null ? !pending.equals(backUrls.pending) : backUrls.pending != null) return false;
        return failure != null ? failure.equals(backUrls.failure) : backUrls.failure == null;
    }

    @Override
    public int hashCode() {
        int result = success != null ? success.hashCode() : 0;
        result = 31 * result + (pending != null ? pending.hashCode() : 0);
        result = 31 * result + (failure != null ? failure.hashCode() : 0);
        return result;
    }
}
