package ar.com.sdd.mercadopago.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

import java.util.Arrays;
import java.util.List;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class MPErrorResponse {

    @JsonProperty("message")
    private String message;
    @JsonProperty("error")
    private String error;
    @JsonProperty("status")
    private Integer status;
    @JsonProperty("cause")
    private List<MPErrorCause> cause;

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getError() {
        return error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public List<MPErrorCause> getCause() {
        return cause;
    }

    public void setCause(List<MPErrorCause> cause) {
        this.cause = cause;
    }

    @Override
    public String toString() {
        return "MPErrorResponse ["
                + ((message != null) ? "message=" + message + ", " : "")
                + ((error != null) ? "error=" + error + ", " : "")
                + ((status != null) ? "status=" + status + ", " : "")
                + ((cause != null) ? "cause=" + Arrays.toString(cause.toArray()) : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        MPErrorResponse that = (MPErrorResponse) o;

        if (message != null ? !message.equals(that.message) : that.message != null) return false;
        if (error != null ? !error.equals(that.error) : that.error != null) return false;
        if (status != null ? !status.equals(that.status) : that.status != null) return false;
        return cause != null ? cause.equals(that.cause) : that.cause == null;
    }

    @Override
    public int hashCode() {
        int result = message != null ? message.hashCode() : 0;
        result = 31 * result + (error != null ? error.hashCode() : 0);
        result = 31 * result + (status != null ? status.hashCode() : 0);
        result = 31 * result + (cause != null ? cause.hashCode() : 0);
        return result;
    }
}
