package ar.com.sdd.mercadopago.entity.preference;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;

/**
 * Mercado Pago SDK
 * Shipment Payment class
 * <p>
 * Created by Eduardo Paoletta on 12/5/16.
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class Shipments {

    public enum ShipmentMode {
        custom,
        me2,
        not_specified
    }
    private ShipmentMode mode = null;
    private Boolean localPickup = null;
    private String dimensions = null;
    private Integer defaultShippingMethod = null;
    private ArrayList<ShippingMethod> freeMethods = null;
    private BigDecimal cost = null;
    private Boolean freeShipping = null;
    private AddressReceiver receiverAddress = null;


    public AddressReceiver getReceiverAddress() {
        return receiverAddress;
    }

    public Shipments setReceiverAddress(AddressReceiver addressReceiver) {
        this.receiverAddress = addressReceiver;
        return this;
    }

    public ShipmentMode getMode() {
        return mode;
    }

    public Shipments setMode(ShipmentMode mode) {
        this.mode = mode;
        return this;
    }

    public Boolean getLocalPickup() {
        return localPickup;
    }

    public Shipments setLocalPickup(Boolean localPickup) {
        this.localPickup = localPickup;
        return this;
    }

    public String getDimensions() {
        return dimensions;
    }

    public Shipments setDimensions(String dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    public Integer getDefaultShippingMethod() {
        return defaultShippingMethod;
    }

    public Shipments setDefaultShippingMethod(Integer defaultShippingMethod) {
        this.defaultShippingMethod = defaultShippingMethod;
        return this;
    }

    public ArrayList<ShippingMethod> getFreeMethods() {
        return freeMethods;
    }

    public Shipments setFreeMethods(ArrayList<ShippingMethod> freeMethods) {
        this.freeMethods = freeMethods;
        return this;
    }

    public ArrayList<ShippingMethod> appendFreeMethods(ShippingMethod freeMethod) {
        if (freeMethods == null)
            freeMethods = new ArrayList<ShippingMethod>();
        freeMethods.add(freeMethod);
        return getFreeMethods();
    }

    public BigDecimal getCost() {
        return cost;
    }

    public Shipments setCost(BigDecimal cost) {
        this.cost = cost;
        return this;
    }

    public Boolean getFreeShipping() {
        return freeShipping;
    }

    public Shipments setFreeShipping(Boolean freeShipping) {
        this.freeShipping = freeShipping;
        return this;
    }

    @Override
    public String toString() {
        return "Shipments ["
                + ((mode != null) ? "mode=" + mode + ", " : "")
                + ((localPickup != null) ? "localPickup=" + localPickup + ", " : "")
                + ((dimensions != null) ? "dimensions=" + dimensions + ", " : "")
                + ((defaultShippingMethod != null) ? "defaultShippingMethod=" + defaultShippingMethod + ", " : "")
                + ((freeMethods != null) ? "freeMethods=" + Arrays.toString(freeMethods.toArray()) + ", " : "")
                + ((cost != null) ? "cost=" + cost + ", " : "")
                + ((freeShipping != null) ? "freeShipping=" + freeShipping + ", " : "")
                + ((receiverAddress != null) ? "receiverAddress=" + receiverAddress : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Shipments shipments = (Shipments) o;

        if (mode != shipments.mode) return false;
        if (localPickup != null ? !localPickup.equals(shipments.localPickup) : shipments.localPickup != null) return false;
        if (dimensions != null ? !dimensions.equals(shipments.dimensions) : shipments.dimensions != null) return false;
        if (defaultShippingMethod != null ? !defaultShippingMethod.equals(shipments.defaultShippingMethod) : shipments.defaultShippingMethod != null) return false;
        if (freeMethods != null ? !freeMethods.equals(shipments.freeMethods) : shipments.freeMethods != null) return false;
        if (cost != null ? !cost.equals(shipments.cost) : shipments.cost != null) return false;
        if (freeShipping != null ? !freeShipping.equals(shipments.freeShipping) : shipments.freeShipping != null) return false;
        return receiverAddress != null ? receiverAddress.equals(shipments.receiverAddress) : shipments.receiverAddress == null;
    }

    @Override
    public int hashCode() {
        int result = mode != null ? mode.hashCode() : 0;
        result = 31 * result + (localPickup != null ? localPickup.hashCode() : 0);
        result = 31 * result + (dimensions != null ? dimensions.hashCode() : 0);
        result = 31 * result + (defaultShippingMethod != null ? defaultShippingMethod.hashCode() : 0);
        result = 31 * result + (freeMethods != null ? freeMethods.hashCode() : 0);
        result = 31 * result + (cost != null ? cost.hashCode() : 0);
        result = 31 * result + (freeShipping != null ? freeShipping.hashCode() : 0);
        result = 31 * result + (receiverAddress != null ? receiverAddress.hashCode() : 0);
        return result;
    }
}
