package ar.com.sdd.mercadopago.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

import java.util.Arrays;
import java.util.List;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class MPPaging<T> {

    private MPPagingUnit paging;
    private List<T> results;

    public MPPaging() {
    }

    public MPPagingUnit getPaging() {
        return paging;
    }

    public void setPaging(MPPagingUnit paging) {
        this.paging = paging;
    }

    public List<T> getResults() {
        return results;
    }

    public void setResults(List<T> results) {
        this.results = results;
    }

    @Override
    public String toString() {
        return "MPPaging ["
                + ((paging != null) ? "paging=" + paging + ", " : "")
                + ((results != null) ? "results=" + Arrays.toString(results.toArray()) : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        MPPaging<?> mpPaging = (MPPaging<?>) o;

        if (paging != null ? !paging.equals(mpPaging.paging) : mpPaging.paging != null) return false;
        return results != null ? results.equals(mpPaging.results) : mpPaging.results == null;
    }

    @Override
    public int hashCode() {
        int result = paging != null ? paging.hashCode() : 0;
        result = 31 * result + (results != null ? results.hashCode() : 0);
        return result;
    }

    public static class MPPagingPayment extends MPPaging<Payment> {

    }
    public static class MPPagingMerchantOrder extends MPPaging<MerchantOrder> {

    }

}
