package ar.com.sdd.mercadopago.entity;

import ar.com.sdd.mercadopago.entity.customer.card.Cardholder;
import ar.com.sdd.mercadopago.entity.customer.card.Issuer;
import ar.com.sdd.mercadopago.entity.customer.card.PaymentMethod;
import ar.com.sdd.mercadopago.entity.customer.card.SecurityCode;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

import java.util.Date;

/**
 * Mercado Pago MercadoPago
 * Retrieves information about a customer's cards.
 * <p>
 * Created by Eduardo Paoletta on 12/15/16.
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class Card {

    private String id = null;
    private String customerId = null;
    private Integer expirationMonth = null;
    private Integer expirationYear = null;
    private String firstSixDigits = null;
    private String lastFourDigits = null;
    private PaymentMethod paymentMethod = null;
    private SecurityCode securityCode = null;
    private Issuer issuer = null;
    private Cardholder cardholder = null;
    private Date dateCreated = null;
    private Date dateLastUpdated = null;
    private String paymentMethodId = null;


    public String getId() {
        return id;
    }

    public Card setId(String id) {
        this.id = id;
        return this;
    }

    public String getCustomerId() {
        return customerId;
    }

    public Card setCustomerId(String customerId) {
        this.customerId = customerId;
        return this;
    }

    public Integer getExpirationMonth() {
        return expirationMonth;
    }

    public Card setExpirationMonth(Integer expirationMonth) {
        this.expirationMonth = expirationMonth;
        return this;
    }

    public Integer getExpirationYear() {
        return expirationYear;
    }

    public Card setExpirationYear(Integer expirationYear) {
        this.expirationYear = expirationYear;
        return this;
    }

    public String getFirstSixDigits() {
        return firstSixDigits;
    }

    public Card setFirstSixDigits(String firstSixDigits) {
        this.firstSixDigits = firstSixDigits;
        return this;
    }

    public String getLastFourDigits() {
        return lastFourDigits;
    }

    public Card setLastFourDigits(String lastFourDigits) {
        this.lastFourDigits = lastFourDigits;
        return this;
    }

    public PaymentMethod getPaymentMethod() {
        return paymentMethod;
    }

    public Card setPaymentMethod(PaymentMethod paymentMethod) {
        this.paymentMethod = paymentMethod;
        return this;
    }

    public SecurityCode getSecurityCode() {
        return securityCode;
    }

    public Card setSecurityCode(SecurityCode securityCode) {
        this.securityCode = securityCode;
        return this;
    }

    public Issuer getIssuer() {
        return issuer;
    }

    public Card setIssuer(Issuer issuer) {
        this.issuer = issuer;
        return this;
    }

    public Cardholder getCardholder() {
        return cardholder;
    }

    public Card setCardholder(Cardholder cardholder) {
        this.cardholder = cardholder;
        return this;
    }

    public Date getDateCreated() {
        return dateCreated;
    }

    public Card setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    public Date getDateLastUpdated() {
        return dateLastUpdated;
    }

    public Card setDateLastUpdated(Date dateLastUpdated) {
        this.dateLastUpdated = dateLastUpdated;
        return this;
    }

    public String getPaymentMethodId() {
        return paymentMethodId;
    }

    public void setPaymentMethodId(String paymentMethodId) {
        this.paymentMethodId = paymentMethodId;
    }

    @Override
    public String toString() {
        return "Card ["
                + ((id != null) ? "id=" + id + ", " : "")
                + ((customerId != null) ? "customerId=" + customerId + ", " : "")
                + ((expirationMonth != null) ? "expirationMonth=" + expirationMonth + ", " : "")
                + ((expirationYear != null) ? "expirationYear=" + expirationYear + ", " : "")
                + ((firstSixDigits != null) ? "firstSixDigits=" + firstSixDigits + ", " : "")
                + ((lastFourDigits != null) ? "lastFourDigits=" + lastFourDigits + ", " : "")
                + ((paymentMethod != null) ? "paymentMethod=" + paymentMethod + ", " : "")
                + ((securityCode != null) ? "securityCode=" + securityCode + ", " : "")
                + ((issuer != null) ? "issuer=" + issuer + ", " : "")
                + ((cardholder != null) ? "cardholder=" + cardholder + ", " : "")
                + ((dateCreated != null) ? "dateCreated=" + dateCreated + ", " : "")
                + ((dateLastUpdated != null) ? "dateLastUpdated=" + dateLastUpdated + ", " : "")
                + ((paymentMethodId != null) ? "paymentMethodId=" + paymentMethodId : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Card card = (Card) o;

        if (id != null ? !id.equals(card.id) : card.id != null) return false;
        if (customerId != null ? !customerId.equals(card.customerId) : card.customerId != null) return false;
        if (expirationMonth != null ? !expirationMonth.equals(card.expirationMonth) : card.expirationMonth != null) return false;
        if (expirationYear != null ? !expirationYear.equals(card.expirationYear) : card.expirationYear != null) return false;
        if (firstSixDigits != null ? !firstSixDigits.equals(card.firstSixDigits) : card.firstSixDigits != null) return false;
        if (lastFourDigits != null ? !lastFourDigits.equals(card.lastFourDigits) : card.lastFourDigits != null) return false;
        if (paymentMethod != null ? !paymentMethod.equals(card.paymentMethod) : card.paymentMethod != null) return false;
        if (securityCode != null ? !securityCode.equals(card.securityCode) : card.securityCode != null) return false;
        if (issuer != null ? !issuer.equals(card.issuer) : card.issuer != null) return false;
        if (cardholder != null ? !cardholder.equals(card.cardholder) : card.cardholder != null) return false;
        if (dateCreated != null ? !dateCreated.equals(card.dateCreated) : card.dateCreated != null) return false;
        if (dateLastUpdated != null ? !dateLastUpdated.equals(card.dateLastUpdated) : card.dateLastUpdated != null) return false;
        return paymentMethodId != null ? paymentMethodId.equals(card.paymentMethodId) : card.paymentMethodId == null;
    }

    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + (customerId != null ? customerId.hashCode() : 0);
        result = 31 * result + (expirationMonth != null ? expirationMonth.hashCode() : 0);
        result = 31 * result + (expirationYear != null ? expirationYear.hashCode() : 0);
        result = 31 * result + (firstSixDigits != null ? firstSixDigits.hashCode() : 0);
        result = 31 * result + (lastFourDigits != null ? lastFourDigits.hashCode() : 0);
        result = 31 * result + (paymentMethod != null ? paymentMethod.hashCode() : 0);
        result = 31 * result + (securityCode != null ? securityCode.hashCode() : 0);
        result = 31 * result + (issuer != null ? issuer.hashCode() : 0);
        result = 31 * result + (cardholder != null ? cardholder.hashCode() : 0);
        result = 31 * result + (dateCreated != null ? dateCreated.hashCode() : 0);
        result = 31 * result + (dateLastUpdated != null ? dateLastUpdated.hashCode() : 0);
        result = 31 * result + (paymentMethodId != null ? paymentMethodId.hashCode() : 0);
        return result;
    }
}
