package ar.com.sdd.mercadopago.entity;

import ar.com.sdd.mercadopago.entity.customer.Address;
import ar.com.sdd.mercadopago.entity.customer.DefaultAddress;
import ar.com.sdd.mercadopago.entity.customer.Identification;
import ar.com.sdd.mercadopago.entity.customer.Phone;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.google.gson.JsonObject;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;

/**
 * Mercado Pago SDK
 * Retrieves information about a customer
 * <p>
 * Created by Eduardo Paoletta on 12/15/16.
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class Customer {

    private String id = null;
    private String email = null;
    private String firstName = null;
    private String lastName = null;
    private Phone phone = null;
    private Identification identification = null;
    private String defaultAddress = null;
    private DefaultAddress address = null;
    private Date dateRegistered = null;
    private String description = null;
    private Date dateCreated = null;
    private Date dateLastUpdated = null;
    private JsonObject metadata = null;
    private String defaultCard = null;
    private ArrayList<Card> cards = null;
    private ArrayList<Address> addresses = null;
    private Boolean liveMode = null;


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getEmail() {
        return email;
    }

    public Customer setEmail(String email) {
        this.email = email;
        return this;
    }

    public String getFirstName() {
        return firstName;
    }

    public Customer setFirstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    public String getLastName() {
        return lastName;
    }

    public Customer setLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public Phone getPhone() {
        return phone;
    }

    public Customer setPhone(Phone phone) {
        this.phone = phone;
        return this;
    }

    public Identification getIdentification() {
        return identification;
    }

    public Customer setIdentification(Identification identification) {
        this.identification = identification;
        return this;
    }

    public String getDefaultAddress() {
        return defaultAddress;
    }

    public Customer setDefaultAddress(String defaultAddress) {
        this.defaultAddress = defaultAddress;
        return this;
    }

    public DefaultAddress getAddress() {
        return address;
    }

    public Customer setAddress(DefaultAddress address) {
        this.address = address;
        return this;
    }

    public Date getDateRegistered() {
        return dateRegistered;
    }

    public Customer setDateRegistered(Date dateRegistered) {
        this.dateRegistered = dateRegistered;
        return this;
    }

    public String getDescription() {
        return description;
    }

    public Customer setDescription(String description) {
        this.description = description;
        return this;
    }

    public Date getDateCreated() {
        return dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public Date getDateLastUpdated() {
        return dateLastUpdated;
    }

    public void setDateLastUpdated(Date dateLastUpdated) {
        this.dateLastUpdated = dateLastUpdated;
    }

    public JsonObject getMetadata() {
        return metadata;
    }

    public Customer setMetadata(JsonObject metadata) {
        this.metadata = metadata;
        return this;
    }

    public String getDefaultCard() {
        return defaultCard;
    }

    public Customer setDefaultCard(String defaultCard) {
        this.defaultCard = defaultCard;
        return this;
    }

    public ArrayList<Card> getCards() {
        return cards;
    }

    public void setCards(ArrayList<Card> cards) {
        this.cards = cards;
    }

    public ArrayList<Address> getAddresses() {
        return addresses;
    }

    public void setAddresses(ArrayList<Address> addresses) {
        this.addresses = addresses;
    }

    public Boolean getLiveMode() {
        return liveMode;
    }

    public void setLiveMode(Boolean liveMode) {
        this.liveMode = liveMode;
    }

    @Override
    public String toString() {
        return "Customer ["
                + ((id != null) ? "id=" + id + ", " : "")
                + ((email != null) ? "email=" + email + ", " : "")
                + ((firstName != null) ? "firstName=" + firstName + ", " : "")
                + ((lastName != null) ? "lastName=" + lastName + ", " : "")
                + ((phone != null) ? "phone=" + phone + ", " : "")
                + ((identification != null) ? "identification=" + identification + ", " : "")
                + ((defaultAddress != null) ? "defaultAddress=" + defaultAddress + ", " : "")
                + ((address != null) ? "address=" + address + ", " : "")
                + ((dateRegistered != null) ? "dateRegistered=" + dateRegistered + ", " : "")
                + ((description != null) ? "description=" + description + ", " : "")
                + ((dateCreated != null) ? "dateCreated=" + dateCreated + ", " : "")
                + ((dateLastUpdated != null) ? "dateLastUpdated=" + dateLastUpdated + ", " : "")
                + ((metadata != null) ? "metadata=" + metadata + ", " : "")
                + ((defaultCard != null) ? "defaultCard=" + defaultCard + ", " : "")
                + ((cards != null) ? "cards=" + Arrays.toString(cards.toArray()) + ", " : "")
                + ((addresses != null) ? "addresses=" + Arrays.toString(addresses.toArray()) + ", " : "")
                + ((liveMode != null) ? "liveMode=" + liveMode : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Customer customer = (Customer) o;

        if (id != null ? !id.equals(customer.id) : customer.id != null) return false;
        if (email != null ? !email.equals(customer.email) : customer.email != null) return false;
        if (firstName != null ? !firstName.equals(customer.firstName) : customer.firstName != null) return false;
        if (lastName != null ? !lastName.equals(customer.lastName) : customer.lastName != null) return false;
        if (phone != null ? !phone.equals(customer.phone) : customer.phone != null) return false;
        if (identification != null ? !identification.equals(customer.identification) : customer.identification != null) return false;
        if (defaultAddress != null ? !defaultAddress.equals(customer.defaultAddress) : customer.defaultAddress != null) return false;
        if (address != null ? !address.equals(customer.address) : customer.address != null) return false;
        if (dateRegistered != null ? !dateRegistered.equals(customer.dateRegistered) : customer.dateRegistered != null) return false;
        if (description != null ? !description.equals(customer.description) : customer.description != null) return false;
        if (dateCreated != null ? !dateCreated.equals(customer.dateCreated) : customer.dateCreated != null) return false;
        if (dateLastUpdated != null ? !dateLastUpdated.equals(customer.dateLastUpdated) : customer.dateLastUpdated != null) return false;
        if (metadata != null ? !metadata.equals(customer.metadata) : customer.metadata != null) return false;
        if (defaultCard != null ? !defaultCard.equals(customer.defaultCard) : customer.defaultCard != null) return false;
        if (cards != null ? !cards.equals(customer.cards) : customer.cards != null) return false;
        if (addresses != null ? !addresses.equals(customer.addresses) : customer.addresses != null) return false;
        return liveMode != null ? liveMode.equals(customer.liveMode) : customer.liveMode == null;
    }

    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + (email != null ? email.hashCode() : 0);
        result = 31 * result + (firstName != null ? firstName.hashCode() : 0);
        result = 31 * result + (lastName != null ? lastName.hashCode() : 0);
        result = 31 * result + (phone != null ? phone.hashCode() : 0);
        result = 31 * result + (identification != null ? identification.hashCode() : 0);
        result = 31 * result + (defaultAddress != null ? defaultAddress.hashCode() : 0);
        result = 31 * result + (address != null ? address.hashCode() : 0);
        result = 31 * result + (dateRegistered != null ? dateRegistered.hashCode() : 0);
        result = 31 * result + (description != null ? description.hashCode() : 0);
        result = 31 * result + (dateCreated != null ? dateCreated.hashCode() : 0);
        result = 31 * result + (dateLastUpdated != null ? dateLastUpdated.hashCode() : 0);
        result = 31 * result + (metadata != null ? metadata.hashCode() : 0);
        result = 31 * result + (defaultCard != null ? defaultCard.hashCode() : 0);
        result = 31 * result + (cards != null ? cards.hashCode() : 0);
        result = 31 * result + (addresses != null ? addresses.hashCode() : 0);
        result = 31 * result + (liveMode != null ? liveMode.hashCode() : 0);
        return result;
    }
}
