package ar.com.sdd.mercadopago.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class MPErrorReport {

    @JsonProperty("cause")
    private MPErrorReportCause cause;
    @JsonProperty("message")
    private String message;
    @JsonProperty("error")
    private String error;

    public MPErrorReportCause getCause() {
        return cause;
    }

    public void setCause(MPErrorReportCause cause) {
        this.cause = cause;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getError() {
        return error;
    }

    public void setError(String error) {
        this.error = error;
    }

    @Override
    public String toString() {
        return "MPErrorReport ["
                + ((cause != null) ? "cause=" + cause + ", " : "")
                + ((message != null) ? "message=" + message + ", " : "")
                + ((error != null) ? "error=" + error : "")
                + "]";
    }
}
