package ar.com.sdd.mercadopago.entity;

import ar.com.sdd.mercadopago.entity.merchantorder.Collector;
import ar.com.sdd.mercadopago.entity.merchantorder.Item;
import ar.com.sdd.mercadopago.entity.merchantorder.MerchantOrderPayment;
import ar.com.sdd.mercadopago.entity.merchantorder.Payer;
import ar.com.sdd.mercadopago.entity.merchantorder.Shipment;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;

/**
 * Mercado Pago MercadoPago
 * This resource allows you to keep  the state of an order, grouping items, payments and shipments.
 * <p>
 * Created by Eduardo Paoletta on 12/13/16.
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class MerchantOrder {

    private String id = null;
    private String preferenceId = null;
    private Date dateCreated = null;
    private Date lastUpdate = null;
    private String applicationId = null;
    private String status = null;
    private String siteId = null;
    private Payer payer = null;
    private Collector collector = null;
    private Integer sponsorId = null;
    private ArrayList<MerchantOrderPayment> payments = null;
    private BigDecimal paidAmount = null;
    private BigDecimal refundedAmount = null;
    private BigDecimal shippingCost = null;
    private Boolean cancelled = null;
    private ArrayList<Item> items = null;
    private ArrayList<Shipment> shipments = null;
    private String notificationUrl = null;
    private String additionalInfo = null;
    private String externalReference = null;
    private String marketplace = null;
    private BigDecimal totalAmount = null;


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getPreferenceId() {
        return preferenceId;
    }

    public MerchantOrder setPreferenceId(String preferenceId) {
        this.preferenceId = preferenceId;
        return this;
    }

    public Date getDateCreated() {
        return dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public Date getLastUpdate() {
        return lastUpdate;
    }

    public void setLastUpdate(Date lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public String getApplicationId() {
        return applicationId;
    }

    public MerchantOrder setApplicationId(String applicationId) {
        this.applicationId = applicationId;
        return this;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getSiteId() {
        return siteId;
    }

    public MerchantOrder setSiteId(String siteId) {
        this.siteId = siteId;
        return this;
    }

    public Payer getPayer() {
        return payer;
    }

    public MerchantOrder setPayer(Payer payer) {
        this.payer = payer;
        return this;
    }

    public Collector getCollector() {
        return collector;
    }

    public MerchantOrder setCollector(Collector collector) {
        this.collector = collector;
        return this;
    }

    public Integer getSponsorId() {
        return sponsorId;
    }

    public MerchantOrder setSponsorId(Integer sponsorId) {
        this.sponsorId = sponsorId;
        return this;
    }

    public ArrayList<MerchantOrderPayment> getPayments() {
        return payments;
    }

    public void setPayments(ArrayList<MerchantOrderPayment> payments) {
        this.payments = payments;
    }

    public BigDecimal getPaidAmount() {
        return paidAmount;
    }

    public void setPaidAmount(BigDecimal paidAmount) {
        this.paidAmount = paidAmount;
    }

    public BigDecimal getRefundedAmount() {
        return refundedAmount;
    }

    public void setRefundedAmount(BigDecimal refundedAmount) {
        this.refundedAmount = refundedAmount;
    }

    public BigDecimal getShippingCost() {
        return shippingCost;
    }

    public void setShippingCost(BigDecimal shippingCost) {
        this.shippingCost = shippingCost;
    }

    public Boolean getCancelled() {
        return cancelled;
    }

    public MerchantOrder setCancelled(Boolean cancelled) {
        this.cancelled = cancelled;
        return this;
    }

    public ArrayList<Item> getItems() {
        return items;
    }

    public MerchantOrder setItems(ArrayList<Item> items) {
        this.items = items;
        return this;
    }

    public MerchantOrder appendItem(Item item) {
        if (items == null) {
            items = new ArrayList<Item>();
        }
        items.add(item);
        return this;
    }

    public ArrayList<Shipment> getShipments() {
        return shipments;
    }

    public MerchantOrder setShipments(ArrayList<Shipment> shipments) {
        this.shipments = shipments;
        return this;
    }

    public MerchantOrder appendShipment(Shipment shipment) {
        if (shipments == null) {
            shipments = new ArrayList<Shipment>();
        }
        shipments.add(shipment);
        return this;
    }

    public String getNotificationUrl() {
        return notificationUrl;
    }

    public MerchantOrder setNotificationUrl(String notificationUrl) {
        this.notificationUrl = notificationUrl;
        return this;
    }

    public String getAdditionalInfo() {
        return additionalInfo;
    }

    public MerchantOrder setAdditionalInfo(String additionalInfo) {
        this.additionalInfo = additionalInfo;
        return this;
    }

    public String getExternalReference() {
        return externalReference;
    }

    public MerchantOrder setExternalReference(String externalReference) {
        this.externalReference = externalReference;
        return this;
    }

    public String getMarketplace() {
        return marketplace;
    }

    public MerchantOrder setMarketplace(String marketplace) {
        this.marketplace = marketplace;
        return this;
    }

    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    @Override
    public String toString() {
        return "MerchantOrder ["
                + ((id != null) ? "id=" + id + ", " : "")
                + ((preferenceId != null) ? "preferenceId=" + preferenceId + ", " : "")
                + ((dateCreated != null) ? "dateCreated=" + dateCreated + ", " : "")
                + ((lastUpdate != null) ? "lastUpdate=" + lastUpdate + ", " : "")
                + ((applicationId != null) ? "applicationId=" + applicationId + ", " : "")
                + ((status != null) ? "status=" + status + ", " : "")
                + ((siteId != null) ? "siteId=" + siteId + ", " : "")
                + ((payer != null) ? "payer=" + payer + ", " : "")
                + ((collector != null) ? "collector=" + collector + ", " : "")
                + ((sponsorId != null) ? "sponsorId=" + sponsorId + ", " : "")
                + ((payments != null) ? "payments=" + Arrays.toString(payments.toArray()) + ", " : "")
                + ((paidAmount != null) ? "paidAmount=" + paidAmount + ", " : "")
                + ((refundedAmount != null) ? "refundedAmount=" + refundedAmount + ", " : "")
                + ((shippingCost != null) ? "shippingCost=" + shippingCost + ", " : "")
                + ((cancelled != null) ? "cancelled=" + cancelled + ", " : "")
                + ((items != null) ? "items=" + Arrays.toString(items.toArray()) + ", " : "")
                + ((shipments != null) ? "shipments=" + Arrays.toString(shipments.toArray()) + ", " : "")
                + ((notificationUrl != null) ? "notificationUrl=" + notificationUrl + ", " : "")
                + ((additionalInfo != null) ? "additionalInfo=" + additionalInfo + ", " : "")
                + ((externalReference != null) ? "externalReference=" + externalReference + ", " : "")
                + ((marketplace != null) ? "marketplace=" + marketplace + ", " : "")
                + ((totalAmount != null) ? "totalAmount=" + totalAmount : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        MerchantOrder that = (MerchantOrder) o;

        if (id != null ? !id.equals(that.id) : that.id != null) return false;
        if (preferenceId != null ? !preferenceId.equals(that.preferenceId) : that.preferenceId != null) return false;
        if (dateCreated != null ? !dateCreated.equals(that.dateCreated) : that.dateCreated != null) return false;
        if (lastUpdate != null ? !lastUpdate.equals(that.lastUpdate) : that.lastUpdate != null) return false;
        if (applicationId != null ? !applicationId.equals(that.applicationId) : that.applicationId != null) return false;
        if (status != null ? !status.equals(that.status) : that.status != null) return false;
        if (siteId != null ? !siteId.equals(that.siteId) : that.siteId != null) return false;
        if (payer != null ? !payer.equals(that.payer) : that.payer != null) return false;
        if (collector != null ? !collector.equals(that.collector) : that.collector != null) return false;
        if (sponsorId != null ? !sponsorId.equals(that.sponsorId) : that.sponsorId != null) return false;
        if (payments != null ? !payments.equals(that.payments) : that.payments != null) return false;
        if (paidAmount != null ? !paidAmount.equals(that.paidAmount) : that.paidAmount != null) return false;
        if (refundedAmount != null ? !refundedAmount.equals(that.refundedAmount) : that.refundedAmount != null) return false;
        if (shippingCost != null ? !shippingCost.equals(that.shippingCost) : that.shippingCost != null) return false;
        if (cancelled != null ? !cancelled.equals(that.cancelled) : that.cancelled != null) return false;
        if (items != null ? !items.equals(that.items) : that.items != null) return false;
        if (shipments != null ? !shipments.equals(that.shipments) : that.shipments != null) return false;
        if (notificationUrl != null ? !notificationUrl.equals(that.notificationUrl) : that.notificationUrl != null) return false;
        if (additionalInfo != null ? !additionalInfo.equals(that.additionalInfo) : that.additionalInfo != null) return false;
        if (externalReference != null ? !externalReference.equals(that.externalReference) : that.externalReference != null) return false;
        if (marketplace != null ? !marketplace.equals(that.marketplace) : that.marketplace != null) return false;
        return totalAmount != null ? totalAmount.equals(that.totalAmount) : that.totalAmount == null;
    }

    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + (preferenceId != null ? preferenceId.hashCode() : 0);
        result = 31 * result + (dateCreated != null ? dateCreated.hashCode() : 0);
        result = 31 * result + (lastUpdate != null ? lastUpdate.hashCode() : 0);
        result = 31 * result + (applicationId != null ? applicationId.hashCode() : 0);
        result = 31 * result + (status != null ? status.hashCode() : 0);
        result = 31 * result + (siteId != null ? siteId.hashCode() : 0);
        result = 31 * result + (payer != null ? payer.hashCode() : 0);
        result = 31 * result + (collector != null ? collector.hashCode() : 0);
        result = 31 * result + (sponsorId != null ? sponsorId.hashCode() : 0);
        result = 31 * result + (payments != null ? payments.hashCode() : 0);
        result = 31 * result + (paidAmount != null ? paidAmount.hashCode() : 0);
        result = 31 * result + (refundedAmount != null ? refundedAmount.hashCode() : 0);
        result = 31 * result + (shippingCost != null ? shippingCost.hashCode() : 0);
        result = 31 * result + (cancelled != null ? cancelled.hashCode() : 0);
        result = 31 * result + (items != null ? items.hashCode() : 0);
        result = 31 * result + (shipments != null ? shipments.hashCode() : 0);
        result = 31 * result + (notificationUrl != null ? notificationUrl.hashCode() : 0);
        result = 31 * result + (additionalInfo != null ? additionalInfo.hashCode() : 0);
        result = 31 * result + (externalReference != null ? externalReference.hashCode() : 0);
        result = 31 * result + (marketplace != null ? marketplace.hashCode() : 0);
        result = 31 * result + (totalAmount != null ? totalAmount.hashCode() : 0);
        return result;
    }
}
