package ar.com.sdd.mercadopago.entity.payment;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

import java.util.Date;

/**
 * Mercado Pago SDK
 * Payer Additional Info Payment class
 * <p>
 * Created by Eduardo Paoletta on 12/2/16.
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class AdditionalInfoPayer {

    private String firstName = null;
    private String lastName = null;
    private Phone phone = null;
    private Address address = null;
    private Date registrationDate = null;

    public String getFirstName() {
        return firstName;
    }

    public AdditionalInfoPayer setFirstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    public String getLastName() {
        return lastName;
    }

    public AdditionalInfoPayer setLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public Phone getPhone() {
        return phone;
    }

    public AdditionalInfoPayer setPhone(Phone phone) {
        this.phone = phone;
        return this;
    }

    public Address getAddress() {
        return address;
    }

    public AdditionalInfoPayer setAddress(Address address) {
        this.address = address;
        return this;
    }

    public Date getRegistrationDate() {
        return registrationDate;
    }

    public AdditionalInfoPayer setRegistrationDate(Date registrationDate) {
        this.registrationDate = registrationDate;
        return this;
    }

    @Override
    public String toString() {
        return "AdditionalInfoPayer ["
                + ((firstName != null) ? "firstName=" + firstName + ", " : "")
                + ((lastName != null) ? "lastName=" + lastName + ", " : "")
                + ((phone != null) ? "phone=" + phone + ", " : "")
                + ((address != null) ? "address=" + address + ", " : "")
                + ((registrationDate != null) ? "registrationDate=" + registrationDate : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AdditionalInfoPayer that = (AdditionalInfoPayer) o;

        if (firstName != null ? !firstName.equals(that.firstName) : that.firstName != null) return false;
        if (lastName != null ? !lastName.equals(that.lastName) : that.lastName != null) return false;
        if (phone != null ? !phone.equals(that.phone) : that.phone != null) return false;
        if (address != null ? !address.equals(that.address) : that.address != null) return false;
        return registrationDate != null ? registrationDate.equals(that.registrationDate) : that.registrationDate == null;
    }

    @Override
    public int hashCode() {
        int result = firstName != null ? firstName.hashCode() : 0;
        result = 31 * result + (lastName != null ? lastName.hashCode() : 0);
        result = 31 * result + (phone != null ? phone.hashCode() : 0);
        result = 31 * result + (address != null ? address.hashCode() : 0);
        result = 31 * result + (registrationDate != null ? registrationDate.hashCode() : 0);
        return result;
    }
}
