package ar.com.sdd.mercadopago.entity.payment;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

import java.util.Date;

/**
 * Mercado Pago SDK
 * Card class
 * <p>
 * Created by Eduardo Paoletta on 12/2/16.
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class Card {

    private Number id = null;
    private String lastFourDigits = null;
    private String firstSixDigits = null;
    private Integer expirationYear = null;
    private Integer expirationMonth = null;
    private Date dateCreated = null;
    private Date dateLastUpdated = null;
    private Cardholder cardholder = null;


    public Number getId() {
        return id;
    }

    public void setId(Number id) {
        this.id = id;
    }

    public String getLastFourDigits() {
        return lastFourDigits;
    }

    public void setLastFourDigits(String lastFourDigits) {
        this.lastFourDigits = lastFourDigits;
    }

    public String getFirstSixDigits() {
        return firstSixDigits;
    }

    public void setFirstSixDigits(String firstSixDigits) {
        this.firstSixDigits = firstSixDigits;
    }

    public Integer getExpirationYear() {
        return expirationYear;
    }

    public void setExpirationYear(Integer expirationYear) {
        this.expirationYear = expirationYear;
    }

    public Integer getExpirationMonth() {
        return expirationMonth;
    }

    public void setExpirationMonth(Integer expirationMonth) {
        this.expirationMonth = expirationMonth;
    }

    public Date getDateCreated() {
        return dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public Date getDateLastUpdated() {
        return dateLastUpdated;
    }

    public void setDateLastUpdated(Date dateLastUpdated) {
        this.dateLastUpdated = dateLastUpdated;
    }

    public Cardholder getCardholder() {
        return cardholder;
    }

    public void setCardholder(Cardholder cardholder) {
        this.cardholder = cardholder;
    }

    @Override
    public String toString() {
        return "Card ["
                + ((id != null) ? "id=" + id + ", " : "")
                + ((lastFourDigits != null) ? "lastFourDigits=" + lastFourDigits + ", " : "")
                + ((firstSixDigits != null) ? "firstSixDigits=" + firstSixDigits + ", " : "")
                + ((expirationYear != null) ? "expirationYear=" + expirationYear + ", " : "")
                + ((expirationMonth != null) ? "expirationMonth=" + expirationMonth + ", " : "")
                + ((dateCreated != null) ? "dateCreated=" + dateCreated + ", " : "")
                + ((dateLastUpdated != null) ? "dateLastUpdated=" + dateLastUpdated + ", " : "")
                + ((cardholder != null) ? "cardholder=" + cardholder : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Card card = (Card) o;

        if (id != null ? !id.equals(card.id) : card.id != null) return false;
        if (lastFourDigits != null ? !lastFourDigits.equals(card.lastFourDigits) : card.lastFourDigits != null) return false;
        if (firstSixDigits != null ? !firstSixDigits.equals(card.firstSixDigits) : card.firstSixDigits != null) return false;
        if (expirationYear != null ? !expirationYear.equals(card.expirationYear) : card.expirationYear != null) return false;
        if (expirationMonth != null ? !expirationMonth.equals(card.expirationMonth) : card.expirationMonth != null) return false;
        if (dateCreated != null ? !dateCreated.equals(card.dateCreated) : card.dateCreated != null) return false;
        if (dateLastUpdated != null ? !dateLastUpdated.equals(card.dateLastUpdated) : card.dateLastUpdated != null) return false;
        return cardholder != null ? cardholder.equals(card.cardholder) : card.cardholder == null;
    }

    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + (lastFourDigits != null ? lastFourDigits.hashCode() : 0);
        result = 31 * result + (firstSixDigits != null ? firstSixDigits.hashCode() : 0);
        result = 31 * result + (expirationYear != null ? expirationYear.hashCode() : 0);
        result = 31 * result + (expirationMonth != null ? expirationMonth.hashCode() : 0);
        result = 31 * result + (dateCreated != null ? dateCreated.hashCode() : 0);
        result = 31 * result + (dateLastUpdated != null ? dateLastUpdated.hashCode() : 0);
        result = 31 * result + (cardholder != null ? cardholder.hashCode() : 0);
        return result;
    }
}
