package ar.com.sdd.mercadopago.entity.preference;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

/**
 * Mercado Pago SDK
 * Payer Preference class
 * <p>
 * Created by Eduardo Paoletta on 12/2/16.
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class Payer {

    private String name = null;
    private String surname = null;
    private String email = null;
    private Phone phone = null;
    private Identification identification = null;
    private Address address = null;
    private String dateCreated = null;


    public String getName() {
        return name;
    }

    public Payer setName(String name) {
        this.name = name;
        return this;
    }

    public String getSurname() {
        return surname;
    }

    public Payer setSurname(String surname) {
        this.surname = surname;
        return this;
    }

    public String getEmail() {
        return email;
    }

    public Payer setEmail(String email) {
        this.email = email;
        return this;
    }

    public Phone getPhone() {
        return phone;
    }

    public Payer setPhone(Phone phone) {
        this.phone = phone;
        return this;
    }

    public Identification getIdentification() {
        return identification;
    }

    public Payer setIdentification(Identification identification) {
        this.identification = identification;
        return this;
    }

    public Address getAddress() {
        return address;
    }

    public Payer setAddress(Address address) {
        this.address = address;
        return this;
    }

    public String getDateCreated() {
        return dateCreated;
    }

    public Payer setDateCreated(String dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    @Override
    public String toString() {
        return "Payer ["
                + ((name != null) ? "name=" + name + ", " : "")
                + ((surname != null) ? "surname=" + surname + ", " : "")
                + ((email != null) ? "email=" + email + ", " : "")
                + ((phone != null) ? "phone=" + phone + ", " : "")
                + ((identification != null) ? "identification=" + identification + ", " : "")
                + ((address != null) ? "address=" + address + ", " : "")
                + ((dateCreated != null) ? "dateCreated=" + dateCreated : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Payer payer = (Payer) o;

        if (name != null ? !name.equals(payer.name) : payer.name != null) return false;
        if (surname != null ? !surname.equals(payer.surname) : payer.surname != null) return false;
        if (email != null ? !email.equals(payer.email) : payer.email != null) return false;
        if (phone != null ? !phone.equals(payer.phone) : payer.phone != null) return false;
        if (identification != null ? !identification.equals(payer.identification) : payer.identification != null) return false;
        if (address != null ? !address.equals(payer.address) : payer.address != null) return false;
        return dateCreated != null ? dateCreated.equals(payer.dateCreated) : payer.dateCreated == null;
    }

    @Override
    public int hashCode() {
        int result = name != null ? name.hashCode() : 0;
        result = 31 * result + (surname != null ? surname.hashCode() : 0);
        result = 31 * result + (email != null ? email.hashCode() : 0);
        result = 31 * result + (phone != null ? phone.hashCode() : 0);
        result = 31 * result + (identification != null ? identification.hashCode() : 0);
        result = 31 * result + (address != null ? address.hashCode() : 0);
        result = 31 * result + (dateCreated != null ? dateCreated.hashCode() : 0);
        return result;
    }
}
