
package ar.com.sdd.mercadopago.entity.user;

import com.fasterxml.jackson.annotation.*;

import java.util.HashMap;
import java.util.Map;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class BuyerReputationTransactions {

    @JsonProperty("canceled")
    private Canceled canceled;
    @JsonProperty("completed")
    private Long completed;
    @JsonProperty("not_yet_rated")
    private NotYetRated notYetRated;
    @JsonProperty("period")
    private String period;
    @JsonProperty("total")
    private Long total;
    @JsonProperty("unrated")
    private Unrated unrated;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @JsonProperty("canceled")
    public Canceled getCanceled() {
        return canceled;
    }

    @JsonProperty("canceled")
    public void setCanceled(Canceled canceled) {
        this.canceled = canceled;
    }

    @JsonProperty("completed")
    public Long getCompleted() {
        return completed;
    }

    @JsonProperty("completed")
    public void setCompleted(Long completed) {
        this.completed = completed;
    }

    @JsonProperty("not_yet_rated")
    public NotYetRated getNotYetRated() {
        return notYetRated;
    }

    @JsonProperty("not_yet_rated")
    public void setNotYetRated(NotYetRated notYetRated) {
        this.notYetRated = notYetRated;
    }

    @JsonProperty("period")
    public String getPeriod() {
        return period;
    }

    @JsonProperty("period")
    public void setPeriod(String period) {
        this.period = period;
    }

    @JsonProperty("total")
    public Long getTotal() {
        return total;
    }

    @JsonProperty("total")
    public void setTotal(Long total) {
        this.total = total;
    }

    @JsonProperty("unrated")
    public Unrated getUnrated() {
        return unrated;
    }

    @JsonProperty("unrated")
    public void setUnrated(Unrated unrated) {
        this.unrated = unrated;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public String toString() {
        return "BuyerReputationTransactions ["
                + ((canceled != null) ? "canceled=" + canceled + ", " : "")
                + ((completed != null) ? "completed=" + completed + ", " : "")
                + ((notYetRated != null) ? "notYetRated=" + notYetRated + ", " : "")
                + ((period != null) ? "period=" + period + ", " : "")
                + ((total != null) ? "total=" + total + ", " : "")
                + ((unrated != null) ? "unrated=" + unrated + ", " : "")
                + ((additionalProperties != null) ? "additionalProperties=" + additionalProperties : "")
                + "]";
    }
}
