package ar.com.sdd.nacionapi.io;

import javax.ws.rs.core.Form;
import java.io.Serializable;
import java.math.BigDecimal;

@SuppressWarnings({"unused", "DuplicatedCode"})
public class GenerateHTMLFormRequest extends Form implements Serializable {

    public String getReferenciaIdentificativa() {
        return asMap().getFirst("referenciaIdentificativa");
    }

    public void setReferenciaIdentificativa(String referenciaIdentificativa) {
        param("referenciaIdentificativa", referenciaIdentificativa);
    }

    public String getCodProducto() {
        return asMap().getFirst("codProducto");
    }

    public void setCodProducto(String codProducto) {
        param("codProducto", codProducto);
    }

    public String getUrlRespuesta() {
        return asMap().getFirst("urlRespuesta");
    }

    public void setUrlRespuesta(String urlRespuesta) {
        param("urlRespuesta", urlRespuesta);
    }

    public Integer getComercio() {
        String comercio = asMap().getFirst("comercio");
        return comercio != null ? Integer.valueOf(comercio) : null;
    }

    public void setComercio(Integer comercio) {
        param("comercio", comercio.toString());
    }

    public Integer getComercioMayorista() {
        String comercioMayorista = asMap().getFirst("comercioMayorista");
        return comercioMayorista != null ? Integer.valueOf(comercioMayorista) : null;
    }

    public void setComercioMayorista(Integer comercioMayorista) {
        param("comercioMayorista", comercioMayorista.toString());
    }

    public BigDecimal getImporteTotal() {
        String importeTotal = asMap().getFirst("importeTotal");
        return importeTotal != null ? new BigDecimal(importeTotal) : null;
    }

    public void setImporteTotal(BigDecimal importeTotal) {
        param("importeTotal", importeTotal.toString());
    }

    public Integer getCantidadCuotas() {
        String cantidadCuotas = asMap().getFirst("cantidadCuotas");
        return cantidadCuotas != null ? Integer.valueOf(cantidadCuotas) : null;
    }

    public void setCantidadCuotas(Integer cantidadCuotas) {
        param("cantidadCuotas", cantidadCuotas.toString());
    }

    public String getCodigoPromocion() {
        return asMap().getFirst("codigoPromocion");
    }

    public void setCodigoPromocion(String codigoPromocion) {
        param("codigoPromocion", codigoPromocion);
    }

    @Override
    public String toString() {
        StringBuilder toString = new StringBuilder("GenerateHTMLFormRequest [");
        String sep = "";
        for (String paramName : asMap().keySet()) {
            toString.append(sep).append(paramName).append("=").append(asMap().getFirst(paramName));
            sep = ", ";
        }
        toString.append("]");
        return toString.toString();
    }
}