package ar.com.sdd.nacionapi.io;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@SuppressWarnings("unused")
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class TransactionStatusResponse extends CommonResponse implements Serializable {

    @JsonProperty("idTransaccion")
    private Integer idTransaccion;

    @JsonProperty("codRespuestaTransaccion")
    private String codRespuestaTransaccion;

    @JsonProperty("descripcionRespuestaTransaccion")
    private String descripcionRespuestaTransaccion;

    @JsonProperty("numeroAutorizacion")
    private String numeroAutorizacion;

    @JsonProperty("codEstado")
    private Integer codEstado;

    @JsonProperty("descripcionEstado")
    private String descripcionEstado;

    @JsonProperty("numeroTarjeta")
    private String numeroTarjeta;

    @JsonProperty("fecha")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX", timezone = "GMT-03:00")
    private Date fecha;

    @JsonProperty("comercio")
    private Integer comercio;

    @JsonProperty("comercioMayorista")
    private Integer comercioMayorista;

    @JsonProperty("importeTotal")
    private BigDecimal importeTotal;

    @JsonProperty("cantidadCuotas")
    private Integer cantidadCuotas;

    @JsonProperty("fechasCuotas")
    private List<String> fechasCuotas;

    @JsonProperty("importesCuotas")
    private List<BigDecimal> importesCuotas;

    @JsonProperty("referenciaIdentificativa")
    private String referenciaIdentificativa;

    public Integer getIdTransaccion() {
        return idTransaccion;
    }

    public void setIdTransaccion(Integer idTransaccion) {
        this.idTransaccion = idTransaccion;
    }

    public String getCodRespuestaTransaccion() {
        return codRespuestaTransaccion;
    }

    public void setCodRespuestaTransaccion(String codRespuestaTransaccion) {
        this.codRespuestaTransaccion = codRespuestaTransaccion;
    }

    public String getDescripcionRespuestaTransaccion() {
        return descripcionRespuestaTransaccion;
    }

    public void setDescripcionRespuestaTransaccion(String descripcionRespuestaTransaccion) {
        this.descripcionRespuestaTransaccion = descripcionRespuestaTransaccion;
    }

    public String getNumeroAutorizacion() {
        return numeroAutorizacion;
    }

    public void setNumeroAutorizacion(String numeroAutorizacion) {
        this.numeroAutorizacion = numeroAutorizacion;
    }

    public Integer getCodEstado() {
        return codEstado;
    }

    public void setCodEstado(Integer codEstado) {
        this.codEstado = codEstado;
    }

    public String getDescripcionEstado() {
        return descripcionEstado;
    }

    public void setDescripcionEstado(String descripcionEstado) {
        this.descripcionEstado = descripcionEstado;
    }

    public String getNumeroTarjeta() {
        return numeroTarjeta;
    }

    public void setNumeroTarjeta(String numeroTarjeta) {
        this.numeroTarjeta = numeroTarjeta;
    }

    public Date getFecha() {
        return fecha;
    }

    public void setFecha(Date fecha) {
        this.fecha = fecha;
    }

    public Integer getComercio() {
        return comercio;
    }

    public void setComercio(Integer comercio) {
        this.comercio = comercio;
    }

    public Integer getComercioMayorista() {
        return comercioMayorista;
    }

    public void setComercioMayorista(Integer comercioMayorista) {
        this.comercioMayorista = comercioMayorista;
    }

    public BigDecimal getImporteTotal() {
        return importeTotal;
    }

    public void setImporteTotal(BigDecimal importeTotal) {
        this.importeTotal = importeTotal;
    }

    public Integer getCantidadCuotas() {
        return cantidadCuotas;
    }

    public void setCantidadCuotas(Integer cantidadCuotas) {
        this.cantidadCuotas = cantidadCuotas;
    }

    public List<String> getFechasCuotas() {
        return fechasCuotas;
    }

    public void setFechasCuotas(List<String> fechasCuotas) {
        this.fechasCuotas = fechasCuotas;
    }

    public List<BigDecimal> getImportesCuotas() {
        return importesCuotas;
    }

    public void setImportesCuotas(List<BigDecimal> importesCuotas) {
        this.importesCuotas = importesCuotas;
    }

    public String getReferenciaIdentificativa() {
        return referenciaIdentificativa;
    }

    public void setReferenciaIdentificativa(String referenciaIdentificativa) {
        this.referenciaIdentificativa = referenciaIdentificativa;
    }

    @Override
    public String toString() {
        return "TransactionStatusResponse [" +
                ((idTransaccion != null) ? "idTransaccion=" + idTransaccion + ", " : "") +
                ((codRespuestaTransaccion != null) ? "codRespuestaTransaccion='" + codRespuestaTransaccion + "', " : "") +
                ((descripcionRespuestaTransaccion != null) ? "descripcionRespuestaTransaccion='" + descripcionRespuestaTransaccion + "', " : "") +
                ((numeroAutorizacion != null) ? "numeroAutorizacion='" + numeroAutorizacion + "', " : "") +
                ((codEstado != null) ? "codEstado=" + codEstado + ", " : "") +
                ((descripcionEstado != null) ? "descripcionEstado='" + descripcionEstado + "', " : "") +
                ((numeroTarjeta != null) ? "numeroTarjeta='" + numeroTarjeta + "', " : "") +
                ((fecha != null) ? "fecha=" + fecha + ", " : "") +
                ((comercio != null) ? "comercio=" + comercio + ", " : "") +
                ((comercioMayorista != null) ? "comercioMayorista=" + comercioMayorista + ", " : "") +
                ((importeTotal != null) ? "importeTotal=" + importeTotal + ", " : "") +
                ((cantidadCuotas != null) ? "cantidadCuotas=" + cantidadCuotas + ", " : "") +
                ((fechasCuotas != null) ? "fechasCuotas=" + Arrays.toString(fechasCuotas.toArray()) + ", " : "") +
                ((importesCuotas != null) ? "importesCuotas=" + Arrays.toString(importesCuotas.toArray()) + ", " : "") +
                ((referenciaIdentificativa != null) ? "referenciaIdentificativa='" + referenciaIdentificativa + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        TransactionStatusResponse that = (TransactionStatusResponse) o;
        return Objects.equals(idTransaccion, that.idTransaccion) && Objects.equals(codRespuestaTransaccion, that.codRespuestaTransaccion) && Objects.equals(descripcionRespuestaTransaccion, that.descripcionRespuestaTransaccion) && Objects.equals(numeroAutorizacion, that.numeroAutorizacion) && Objects.equals(codEstado, that.codEstado) && Objects.equals(descripcionEstado, that.descripcionEstado) && Objects.equals(numeroTarjeta, that.numeroTarjeta) && Objects.equals(fecha, that.fecha) && Objects.equals(comercio, that.comercio) && Objects.equals(comercioMayorista, that.comercioMayorista) && Objects.equals(importeTotal, that.importeTotal) && Objects.equals(cantidadCuotas, that.cantidadCuotas) && Objects.equals(fechasCuotas, that.fechasCuotas) && Objects.equals(importesCuotas, that.importesCuotas) && Objects.equals(referenciaIdentificativa, that.referenciaIdentificativa);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), idTransaccion, codRespuestaTransaccion, descripcionRespuestaTransaccion, numeroAutorizacion, codEstado, descripcionEstado, numeroTarjeta, fecha, comercio, comercioMayorista, importeTotal, cantidadCuotas, fechasCuotas, importesCuotas, referenciaIdentificativa);
    }
}