/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.nacionapi.core;

import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.commons.rest.model.TokenOAuth2;
import ar.com.sdd.commons.util.SimpleCache;
import ar.com.sdd.commons.util.SimpleCacheManager;
import ar.com.sdd.commons.util.ThreadUtil;
import ar.com.sdd.nacionapi.core.NacionApiConnectorContext;
import ar.com.sdd.nacionapi.io.AuthorizeTransactionRequest;
import ar.com.sdd.nacionapi.io.AuthorizeTransactionResponse;
import ar.com.sdd.nacionapi.io.CommonResponse;
import ar.com.sdd.nacionapi.io.GenerateHTMLFormRequest;
import ar.com.sdd.nacionapi.io.GenerateHTMLFormResponse;
import ar.com.sdd.nacionapi.io.GetPromotionsRequest;
import ar.com.sdd.nacionapi.io.GetPromotionsResponse;
import ar.com.sdd.nacionapi.io.TransactionStatusRequest;
import ar.com.sdd.nacionapi.io.TransactionStatusResponse;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NacionApiConnector
implements RestSecurityManager {
    private static final Logger log = LogManager.getLogger(NacionApiConnector.class);
    private final RestConnector restConnector;
    private final String accessTokenBaseUrl;
    private final String username;
    private final String password;
    private static final int MAX_RETRIES = 3;
    private static final int RETRY_WAIT_MILIS = 200;

    public NacionApiConnector(NacionApiConnectorContext context) {
        this.accessTokenBaseUrl = context.getAccessTokenBaseUrl();
        this.username = context.getUsername();
        this.password = context.getPassword();
        log.trace("Creando NacionApiConnector para url [{}]", (Object)context.getBaseUrl());
        RestConnectorEnvironment environment = new RestConnectorEnvironment(context.getBaseUrl());
        this.restConnector = new RestConnector(environment, (RestSecurityManager)this);
    }

    public GenerateHTMLFormResponse generateHTMLForm(GenerateHTMLFormRequest request) throws RestConnectorException {
        String path = "/formularioAutorizacion";
        log.debug("[generateHTMLForm] Request POST por pedir el formulario HTML al banco, request [{}] path [{}]", (Object)request, (Object)"/formularioAutorizacion");
        RestConnectorException lastException = null;
        for (int retry = 3; retry > 0; --retry) {
            try {
                return (GenerateHTMLFormResponse)this.restConnector.genericPost((Object)request, GenerateHTMLFormResponse.class, CommonResponse.class, "/formularioAutorizacion", "application/json", "application/x-www-form-urlencoded");
            }
            catch (RestConnectorException e) {
                lastException = e;
                if (e.getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                    this.getAccessToken(true);
                }
                ThreadUtil.sleep((long)200L);
                continue;
            }
        }
        throw lastException;
    }

    public GetPromotionsResponse getPromotions(GetPromotionsRequest request) throws RestConnectorException {
        String path = "/obtenerPromociones";
        log.debug("[getPromotions] Request POST por obtener promociones, request [{}] path [{}]", (Object)request, (Object)"/obtenerPromociones");
        RestConnectorException lastException = null;
        for (int retry = 3; retry > 0; --retry) {
            try {
                return (GetPromotionsResponse)this.restConnector.genericPost((Object)request, GetPromotionsResponse.class, CommonResponse.class, "/obtenerPromociones", "application/json", "application/x-www-form-urlencoded");
            }
            catch (RestConnectorException e) {
                lastException = e;
                if (e.getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                    this.getAccessToken(true);
                }
                ThreadUtil.sleep((long)200L);
                continue;
            }
        }
        throw lastException;
    }

    public AuthorizeTransactionResponse authorizeTransaction(AuthorizeTransactionRequest request) throws RestConnectorException {
        String path = "/obtenerPromociones";
        log.debug("[authorizeTransaction] Request POST por autorizar transaccion, request [{}] path [{}]", (Object)request, (Object)"/obtenerPromociones");
        RestConnectorException lastException = null;
        for (int retry = 3; retry > 0; --retry) {
            try {
                return (AuthorizeTransactionResponse)this.restConnector.genericPost((Object)request, AuthorizeTransactionResponse.class, CommonResponse.class, "/obtenerPromociones", "application/json", "application/x-www-form-urlencoded");
            }
            catch (RestConnectorException e) {
                lastException = e;
                if (e.getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                    this.getAccessToken(true);
                }
                ThreadUtil.sleep((long)200L);
                continue;
            }
        }
        throw lastException;
    }

    public TransactionStatusResponse getTransactionStatus(TransactionStatusRequest request) throws RestConnectorException {
        String path = "/consultaTransaccion";
        log.debug("[getTransactionStatus] Request POST por consultar el estado de una transaccion, request [{}] path [{}]", (Object)request, (Object)"/consultaTransaccion");
        RestConnectorException lastException = null;
        for (int retry = 3; retry > 0; --retry) {
            try {
                return (TransactionStatusResponse)this.restConnector.genericPost((Object)request, TransactionStatusResponse.class, CommonResponse.class, "/consultaTransaccion", "application/json", "application/x-www-form-urlencoded");
            }
            catch (RestConnectorException e) {
                lastException = e;
                if (e.getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                    this.getAccessToken(true);
                }
                ThreadUtil.sleep((long)200L);
                continue;
            }
        }
        throw lastException;
    }

    public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
        if (builder != null) {
            builder.header("Authorization", (Object)("Bearer " + this.getAccessToken(false)));
        }
        return builder;
    }

    public boolean getDisableHTTPSErrors() {
        return false;
    }

    public String getAccessToken(boolean force) throws RestConnectorException {
        SimpleCache cache = SimpleCacheManager.getInstance().getCache(NacionApiConnector.class.getName());
        String cacheKey = SimpleCacheManager.buildKey((Object[])new Object[]{"accessToken"});
        String accessToken = (String)cache.get(cacheKey);
        if (force || accessToken == null) {
            Form form = new Form();
            form.param("username", this.username);
            form.param("password", this.password);
            form.param("grant_type", "password");
            log.debug("[getAccessToken] Por recuperar token con username [{}] y password [{}]", (Object)this.username, (Object)this.password);
            RestConnector connector = new RestConnector(new RestConnectorEnvironment(this.accessTokenBaseUrl), null);
            TokenOAuth2 tokenOAuth2Response = (TokenOAuth2)connector.genericPost((Object)form, TokenOAuth2.class, "/auth/realms/WebTarjeta/protocol/openid-connect/token", "application/json", "application/x-www-form-urlencoded");
            log.debug("[getAccessToken] Token recuperado [{}]. Expira en [{}] segs. Lo agrego al a cache", (Object)tokenOAuth2Response, (Object)tokenOAuth2Response.getExpiresIn());
            accessToken = tokenOAuth2Response.getAccessToken();
            cache.put(cacheKey, (Object)accessToken, Integer.valueOf(tokenOAuth2Response.getExpiresIn() - 10));
        }
        return accessToken;
    }
}

