package ar.com.sdd.nacionapi.io;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class AuthorizeTransactionResponse extends CommonResponse implements Serializable {

    @JsonProperty("idTransaccion")
    private Integer idTransaccion;

    @JsonProperty("numeroAutorizacion")
    private String numeroAutorizacion;

    @JsonProperty("referenciaIdentificativa")
    private String referenciaIdentificativa;

    public Integer getIdTransaccion() {
        return idTransaccion;
    }

    public void setIdTransaccion(Integer idTransaccion) {
        this.idTransaccion = idTransaccion;
    }

    public String getNumeroAutorizacion() {
        return numeroAutorizacion;
    }

    public void setNumeroAutorizacion(String numeroAutorizacion) {
        this.numeroAutorizacion = numeroAutorizacion;
    }

    public String getReferenciaIdentificativa() {
        return referenciaIdentificativa;
    }

    public void setReferenciaIdentificativa(String referenciaIdentificativa) {
        this.referenciaIdentificativa = referenciaIdentificativa;
    }

    @Override
    public String toString() {
        return "AuthorizeTransactionResponse [" +
                ((getCodRespuesta() != null) ? "codRespuesta='" + getCodRespuesta() + "', " : "") +
                ((getDescripcionRespuesta() != null) ? "descripcionRespuesta='" + getDescripcionRespuesta() + "', " : "") +
                ((idTransaccion != null) ? "idTransaccion=" + idTransaccion + ", " : "") +
                ((numeroAutorizacion != null) ? "numeroAutorizacion='" + numeroAutorizacion + "', " : "") +
                ((referenciaIdentificativa != null) ? "referenciaIdentificativa='" + referenciaIdentificativa + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        AuthorizeTransactionResponse that = (AuthorizeTransactionResponse) o;
        return Objects.equals(idTransaccion, that.idTransaccion) && Objects.equals(numeroAutorizacion, that.numeroAutorizacion) && Objects.equals(referenciaIdentificativa, that.referenciaIdentificativa);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), idTransaccion, numeroAutorizacion, referenciaIdentificativa);
    }
}