package ar.com.sdd.nacionapi.io;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class CommonResponse implements Serializable {

    @JsonProperty("codRespuesta")
    private String codRespuesta;

    @JsonProperty("descripcionRespuesta")
    private String descripcionRespuesta;

    public String getCodRespuesta() {
        return codRespuesta;
    }

    public void setCodRespuesta(String codRespuesta) {
        this.codRespuesta = codRespuesta;
    }

    public String getDescripcionRespuesta() {
        return descripcionRespuesta;
    }

    public void setDescripcionRespuesta(String descripcionRespuesta) {
        this.descripcionRespuesta = descripcionRespuesta;
    }

    @Override
    public String toString() {
        return "CommonResponse [" +
                ((codRespuesta != null) ? "codRespuesta='" + codRespuesta + "', " : "") +
                ((descripcionRespuesta != null) ? "descripcionRespuesta='" + descripcionRespuesta + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CommonResponse that = (CommonResponse) o;
        return Objects.equals(codRespuesta, that.codRespuesta) && Objects.equals(descripcionRespuesta, that.descripcionRespuesta);
    }

    @Override
    public int hashCode() {
        return Objects.hash(codRespuesta, descripcionRespuesta);
    }
}