package ar.com.sdd.nacionapi.io;

import ar.com.sdd.commons.util.DateUtil;
import ar.com.sdd.commons.util.NumberUtil;
import ar.com.sdd.commons.util.StringUtil;

import javax.ws.rs.core.Form;
import javax.ws.rs.core.MultivaluedMap;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@SuppressWarnings({"unused", "DuplicatedCode"})
public class AuthorizeTransactionRequest extends Form implements Serializable {

    public String getReferenciaIdentificativa() {
        return asMap().getFirst("referenciaIdentificativa");
    }

    public void setReferenciaIdentificativa(String referenciaIdentificativa) {
        param("referenciaIdentificativa", referenciaIdentificativa);
    }

    public String getNumeroTarjeta() {
        return asMap().getFirst("numeroTarjeta");
    }

    public void setNumeroTarjeta(String numeroTarjeta) {
        this.param("numeroTarjeta", numeroTarjeta);
    }

    public Integer getMmValidezHasta() {
        String mmValidezHasta = asMap().getFirst("mmValidezHasta");
        return mmValidezHasta != null ? Integer.valueOf(mmValidezHasta) : null;
    }

    public void setMmValidezHasta(Integer mmValidezHasta) {
        this.param("mmValidezHasta", StringUtil.padCustomLeft(mmValidezHasta.toString(), 2, '0'));
    }

    public Integer getYyyyValidezHasta() {
        String yyyyValidezHasta = asMap().getFirst("yyyyValidezHasta");
        return yyyyValidezHasta != null ? Integer.valueOf(yyyyValidezHasta) : null;
    }

    public void setYyyyValidezHasta(Integer yyyyValidezHasta) {
        this.param("yyyyValidezHasta", StringUtil.padCustomLeft(yyyyValidezHasta.toString(), 2, '0'));
    }

    public String getCodigoSeguridad() {
        return asMap().getFirst("codigoSeguridad");
    }

    public void setCodigoSeguridad(String codigoSeguridad) {
        this.param("codigoSeguridad", codigoSeguridad);
    }

    public BigDecimal getImporteTotal() {
        String importeTotal = asMap().getFirst("importeTotal");
        return importeTotal != null ? new BigDecimal(importeTotal) : null;
    }

    public void setImporteTotal(BigDecimal importeTotal) {
        param("importeTotal", importeTotal.toString());
    }

    public Integer getCantidadCuotas() {
        String cantidadCuotas = asMap().getFirst("cantidadCuotas");
        return cantidadCuotas != null ? Integer.valueOf(cantidadCuotas) : null;
    }

    public void setCantidadCuotas(Integer cantidadCuotas) {
        param("cantidadCuotas", cantidadCuotas.toString());
    }

    public Date getFechaCuota(String nroCuota) {
        nroCuota = StringUtil.padCustomLeft(nroCuota, 2, '0');
        MultivaluedMap<String, String> params = this.asMap();
        if (params != null && params.containsKey("fechaCuota" + nroCuota)) {
            return DateUtil.parseJsonDate(params.get("fechaCuota" + nroCuota).iterator().next());
        }
        return null;
    }

    public void setFechaCuota(String nroCuota, Date fechaCuota) {
        nroCuota = StringUtil.padCustomLeft(nroCuota, 2, '0');
        this.param("fechaCuota" + nroCuota, DateUtil.formatJsonDate(fechaCuota));
    }

    public BigDecimal getImporteCuota(String nroCuota) {
        nroCuota = StringUtil.padCustomLeft(nroCuota, 2, '0');
        MultivaluedMap<String, String> params = this.asMap();
        if (params != null && params.containsKey("importeCuota" + nroCuota)) {
            return NumberUtil.newBigDecimal(params.get("importeCuota" + nroCuota).iterator().next());
        }
        return null;
    }

    public void setImporteCuota(String nroCuota, BigDecimal importeCuota) {
        nroCuota = StringUtil.padCustomLeft(nroCuota, 2, '0');
        this.param("importeCuota" + nroCuota, importeCuota.toString());
    }

    public String getCodProducto() {
        return asMap().getFirst("codProducto");
    }

    public void setCodProducto(String codProducto) {
        param("codProducto", codProducto);
    }

    public Integer getComercio() {
        String comercio = asMap().getFirst("comercio");
        return comercio != null ? Integer.valueOf(comercio) : null;
    }

    public void setComercio(Integer comercio) {
        param("comercio", comercio.toString());
    }

    public Integer getComercioMayorista() {
        String comercioMayorista = asMap().getFirst("comercioMayorista");
        return comercioMayorista != null ? Integer.valueOf(comercioMayorista) : null;
    }

    public void setComercioMayorista(Integer comercioMayorista) {
        param("comercioMayorista", comercioMayorista.toString());
    }

    public String getCodigoPromocion() {
        return asMap().getFirst("codigoPromocion");
    }

    public void setCodigoPromocion(String codigoPromocion) {
        param("codigoPromocion", codigoPromocion);
    }

    @Override
    public String toString() {
        StringBuilder toString = new StringBuilder("AuthorizeTransactionRequest [");
        String sep = "";
        for (String paramName : asMap().keySet()) {
            toString.append(sep).append(paramName).append("=").append(asMap().getFirst(paramName));
            sep = ", ";
        }
        toString.append("]");
        return toString.toString();
    }
}