package ar.com.sdd.nacionapi.io;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class GenerateHTMLFormResponse extends CommonResponse implements Serializable {

    @JsonProperty("formUrl")
    private String formUrl;

    public String getFormUrl() {
        return formUrl;
    }

    public void setFormUrl(String formUrl) {
        this.formUrl = formUrl;
    }

    @Override
    public String toString() {
        return "GenerateHTMLFormResponse [" +
                ((getCodRespuesta() != null) ? "codRespuesta='" + getCodRespuesta() + "', " : "") +
                ((getDescripcionRespuesta() != null) ? "descripcionRespuesta='" + getDescripcionRespuesta() + "', " : "") +
                ((formUrl != null) ? "formUrl='" + formUrl + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GenerateHTMLFormResponse that = (GenerateHTMLFormResponse) o;
        return Objects.equals(getCodRespuesta(), that.getCodRespuesta()) && Objects.equals(getDescripcionRespuesta(), that.getDescripcionRespuesta()) && Objects.equals(formUrl, that.formUrl);
    }

    @Override
    public int hashCode() {
        return Objects.hash(getCodRespuesta(), getDescripcionRespuesta(), formUrl);
    }
}