package ar.com.sdd.nacionapi.io;

import ar.com.sdd.nacionapi.model.Promotion;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class GetPromotionsResponse extends CommonResponse implements Serializable {

    @JsonProperty("promociones")
    private List<Promotion> promociones;

    public List<Promotion> getPromociones() {
        return promociones;
    }

    public void setPromociones(List<Promotion> promociones) {
        this.promociones = promociones;
    }

    @Override
    public String toString() {
        return "GetPromotionsResponse [" +
                ((getCodRespuesta() != null) ? "codRespuesta='" + getCodRespuesta() + "', " : "") +
                ((getDescripcionRespuesta() != null) ? "descripcionRespuesta='" + getDescripcionRespuesta() + "', " : "") +
                ((promociones != null) ? "promociones=" + Arrays.toString(promociones.toArray()) + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        GetPromotionsResponse that = (GetPromotionsResponse) o;
        return Objects.equals(getCodRespuesta(), that.getCodRespuesta()) && Objects.equals(getDescripcionRespuesta(), that.getDescripcionRespuesta()) && Objects.equals(promociones, that.promociones);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), getCodRespuesta(), getDescripcionRespuesta(), promociones);
    }
}