package ar.com.sdd.nacionapi.io;

import ar.com.sdd.commons.util.DateUtil;
import ar.com.sdd.commons.util.NumberUtil;
import ar.com.sdd.commons.util.StringUtil;

import javax.ws.rs.core.Form;
import javax.ws.rs.core.MultivaluedMap;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@SuppressWarnings({"unused", "DuplicatedCode"})
public class TransactionStatusRequest extends Form implements Serializable {

    public Integer getComercio() {
        String comercio = asMap().getFirst("comercio");
        return comercio != null ? Integer.valueOf(comercio) : null;
    }

    public void setComercio(Integer comercio) {
        param("comercio", comercio.toString());
    }

    public String getReferenciaIdentificativa() {
        return asMap().getFirst("referenciaIdentificativa");
    }

    public void setReferenciaIdentificativa(String referenciaIdentificativa) {
        param("referenciaIdentificativa", referenciaIdentificativa);
    }

    public String getIdTransaccion() {
        return asMap().getFirst("idTransaccion");
    }

    public void setIdTransaccion(String codProducto) {
        param("idTransaccion", codProducto);
    }

    @Override
    public String toString() {
        StringBuilder toString = new StringBuilder("TransactionStatusRequest [");
        String sep = "";
        for (String paramName : asMap().keySet()) {
            toString.append(sep).append(paramName).append("=").append(asMap().getFirst(paramName));
            sep = ", ";
        }
        toString.append("]");
        return toString.toString();
    }
}