package ar.com.sdd.nacionapi.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Promotion implements Serializable {

    @JsonProperty("codigo")
    private Integer codigo;

    @JsonProperty("descripcion")
    private String descripcion;

    @JsonProperty("detalle")
    private String detalle;

    @JsonProperty("precioModificable")
    private Boolean precioModificable;

    @JsonProperty("socioValor")
    private Boolean socioValor;

    @JsonProperty("cuotasMinimas")
    private Integer cuotasMinimas;

    @JsonProperty("cuotasMaximas")
    private Integer cuotasMaximas;

    @JsonProperty("vigenciaDesde")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date vigenciaDesde;

    @JsonProperty("vigenciaHasta")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date vigenciaHasta;

    public Integer getCodigo() {
        return codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
    }

    public String getDescripcion() {
        return descripcion;
    }

    public void setDescripcion(String descripcion) {
        this.descripcion = descripcion;
    }

    public String getDetalle() {
        return detalle;
    }

    public void setDetalle(String detalle) {
        this.detalle = detalle;
    }

    public Boolean getPrecioModificable() {
        return precioModificable;
    }

    public void setPrecioModificable(Boolean precioModificable) {
        this.precioModificable = precioModificable;
    }

    public Boolean getSocioValor() {
        return socioValor;
    }

    public void setSocioValor(Boolean socioValor) {
        this.socioValor = socioValor;
    }

    public Integer getCuotasMinimas() {
        return cuotasMinimas;
    }

    public void setCuotasMinimas(Integer cuotasMinimas) {
        this.cuotasMinimas = cuotasMinimas;
    }

    public Integer getCuotasMaximas() {
        return cuotasMaximas;
    }

    public void setCuotasMaximas(Integer cuotasMaximas) {
        this.cuotasMaximas = cuotasMaximas;
    }

    public Date getVigenciaDesde() {
        return vigenciaDesde;
    }

    public void setVigenciaDesde(Date vigenciaDesde) {
        this.vigenciaDesde = vigenciaDesde;
    }

    public Date getVigenciaHasta() {
        return vigenciaHasta;
    }

    public void setVigenciaHasta(Date vigenciaHasta) {
        this.vigenciaHasta = vigenciaHasta;
    }

    @Override
    public String toString() {
        return "Promotion [" +
                ((codigo != null) ? "codigo=" + codigo + ", " : "") +
                ((descripcion != null) ? "descripcion='" + descripcion + "', " : "") +
                ((detalle != null) ? "detalle='" + detalle + "', " : "") +
                ((precioModificable != null) ? "precioModificable=" + precioModificable + ", " : "") +
                ((socioValor != null) ? "socioValor=" + socioValor + ", " : "") +
                ((cuotasMinimas != null) ? "cuotasMinimas=" + cuotasMinimas + ", " : "") +
                ((cuotasMaximas != null) ? "cuotasMaximas=" + cuotasMaximas + ", " : "") +
                ((vigenciaDesde != null) ? "vigenciaDesde=" + vigenciaDesde + ", " : "") +
                ((vigenciaHasta != null) ? "vigenciaHasta=" + vigenciaHasta + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Promotion promotion = (Promotion) o;
        return Objects.equals(codigo, promotion.codigo) && Objects.equals(descripcion, promotion.descripcion) && Objects.equals(detalle, promotion.detalle) && Objects.equals(precioModificable, promotion.precioModificable) && Objects.equals(socioValor, promotion.socioValor) && Objects.equals(cuotasMinimas, promotion.cuotasMinimas) && Objects.equals(cuotasMaximas, promotion.cuotasMaximas) && Objects.equals(vigenciaDesde, promotion.vigenciaDesde) && Objects.equals(vigenciaHasta, promotion.vigenciaHasta);
    }

    @Override
    public int hashCode() {
        return Objects.hash(codigo, descripcion, detalle, precioModificable, socioValor, cuotasMinimas, cuotasMaximas, vigenciaDesde, vigenciaHasta);
    }
}