package ar.com.sdd.odceapi.client.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
public class OdceDocumentSet implements Serializable {

        @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
        private Date   processDate = null;
        private String trackingNumber = "";
        private BigDecimal exchangeRate = null;

        private List<OdceDocument> documents = null;

    public Date getProcessDate() {
        return processDate;
    }

    public void setProcessDate(Date processDate) {
        this.processDate = processDate;
    }

    public String getTrackingNumber() {
        return trackingNumber;
    }

    public void setTrackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
    }

    public BigDecimal getExchangeRate() {
        return exchangeRate;
    }

    public void setExchangeRate(BigDecimal exchangeRate) {
        this.exchangeRate = exchangeRate;
    }

    public List<OdceDocument> getDocuments() {
        return documents;
    }

    public void setDocuments(List<OdceDocument> documents) {
        this.documents = documents;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        OdceDocumentSet that = (OdceDocumentSet) o;
        return Objects.equals(processDate, that.processDate) && Objects.equals(trackingNumber, that.trackingNumber) && Objects.equals(exchangeRate, that.exchangeRate) && Objects.equals(documents, that.documents);
    }

    @Override
    public int hashCode() {
        return Objects.hash(processDate, trackingNumber, exchangeRate, documents);
    }

    @Override
    public String toString() {
        return "OdceDocumentSet [" +
                ((processDate != null) ? "processDate=" + processDate + ", " : "") +
                ((trackingNumber != null) ? "trackingNumber='" + trackingNumber + "', " : "") +
                ((exchangeRate != null) ? "exchangeRate=" + exchangeRate + ", " : "") +
                ((documents != null) ? "documents=" + Arrays.toString(documents.toArray()) + ", " : "") +
                "]";
    }
}
