package ar.com.sdd.odceapi.client.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.io.Serializable;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
public class OdcePaymentLink implements Serializable {
    private String actionUrl;
    private String trackingNumber;
    private String orderNumber;
    private String expiresIn;

    public String getActionUrl() {
        return actionUrl;
    }

    public void setActionUrl(String actionUrl) {
        this.actionUrl = actionUrl;
    }

    public String getTrackingNumber() {
        return trackingNumber;
    }

    public void setTrackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
    }

    public String getOrderNumber() {
        return orderNumber;
    }

    public void setOrderNumber(String orderNumber) {
        this.orderNumber = orderNumber;
    }

    public String getExpiresIn() {
        return expiresIn;
    }

    public void setExpiresIn(String expiresIn) {
        this.expiresIn = expiresIn;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        OdcePaymentLink that = (OdcePaymentLink) o;
        return Objects.equals(actionUrl, that.actionUrl) && Objects.equals(trackingNumber, that.trackingNumber) && Objects.equals(orderNumber, that.orderNumber) && Objects.equals(expiresIn, that.expiresIn);
    }

    @Override
    public int hashCode() {
        return Objects.hash(actionUrl, trackingNumber, orderNumber, expiresIn);
    }

    @Override
    public String toString() {
        return "OdcePaymentLink [" +
                ((actionUrl != null) ? "actionUrl='" + actionUrl + "', " : "") +
                ((trackingNumber != null) ? "trackingNumber='" + trackingNumber + "', " : "") +
                ((orderNumber != null) ? "orderNumber='" + orderNumber + "', " : "") +
                ((expiresIn != null) ? "expiresIn='" + expiresIn + "', " : "") +
                "]";
    }
}
