package ar.com.sdd.odceapi.client.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
public class OdcePaymentSet implements Serializable {

    private List<OdcePayment> payments;

    public List<OdcePayment> getPayments() {
        return payments;
    }

    public void setPayments(List<OdcePayment> payments) {
        this.payments = payments;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        OdcePaymentSet that = (OdcePaymentSet) o;
        return Objects.equals(payments, that.payments);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(payments);
    }

    @Override
    public String toString() {
        return "OdcePaymentSet [" +
                ((payments != null) ? "payments=" + Arrays.toString(payments.toArray()) + ", " : "") +
                "]";
    }
}
