package ar.com.sdd.odceapi.client.core;

import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.odceapi.client.model.OdcePaymentStatusInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Response;

public class OdceApiConnector implements RestSecurityManager {

    private final static Logger log = LogManager.getLogger(OdceApiConnector.class);

    protected final RestConnector restConnector;

    public OdceApiConnector(OdceApiConnectorContext context) {
        log.debug("Creando PatagoniaApiConnector con " + context);
        RestConnectorEnvironment environment = new RestConnectorEnvironment(context.getBaseUrl());
        restConnector = new RestConnector(environment, this);
    }

    public void notifyPaymentChange(OdcePaymentStatusInfo odcePaymentStatusInfo) throws RestConnectorException {
        // TODO: TBD
    }

    @Override
    public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
        return builder;
    }

    @Override
    public boolean retryOnUnauthorized() {
        return false;
    }

    @Override
    public boolean getDisableHTTPSErrors() {
        return false;
    }
}