package ar.com.sdd.odceapi.client.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;

@SuppressWarnings("unused")
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class OdcePaymentStatusInfo implements Serializable {

    private String orderNumber;
    private String legalDocRef;
    private String ownerDocRef;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date dueDate;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date creditDate;
    private BigDecimal dueAmount;
    private String status;
    private String comments;

    public OdcePaymentStatusInfo() {
    }

    public OdcePaymentStatusInfo(String orderNumber, String legalDocRef, String ownerDocRef, Date dueDate, Date creditDate, BigDecimal dueAmount, String status, String comments) {
        this.orderNumber = orderNumber;
        this.legalDocRef = legalDocRef;
        this.ownerDocRef = ownerDocRef;
        this.dueDate = dueDate;
        this.creditDate = creditDate;
        this.dueAmount = dueAmount;
        this.status = status;
        this.comments = comments;
    }

    public String getOrderNumber() {
        return orderNumber;
    }

    public void setOrderNumber(String orderNumber) {
        this.orderNumber = orderNumber;
    }

    public String getLegalDocRef() {
        return legalDocRef;
    }

    public void setLegalDocRef(String legalDocRef) {
        this.legalDocRef = legalDocRef;
    }

    public String getOwnerDocRef() {
        return ownerDocRef;
    }

    public void setOwnerDocRef(String ownerDocRef) {
        this.ownerDocRef = ownerDocRef;
    }

    public Date getDueDate() {
        return dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public Date getCreditDate() {
        return creditDate;
    }

    public void setCreditDate(Date creditDate) {
        this.creditDate = creditDate;
    }

    public BigDecimal getDueAmount() {
        return dueAmount;
    }

    public void setDueAmount(BigDecimal dueAmount) {
        this.dueAmount = dueAmount;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getComments() {
        return comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        OdcePaymentStatusInfo that = (OdcePaymentStatusInfo) o;
        return Objects.equals(orderNumber, that.orderNumber) && Objects.equals(legalDocRef, that.legalDocRef) && Objects.equals(ownerDocRef, that.ownerDocRef) && Objects.equals(dueDate, that.dueDate) && Objects.equals(creditDate, that.creditDate) && Objects.equals(dueAmount, that.dueAmount) && Objects.equals(status, that.status) && Objects.equals(comments, that.comments);
    }

    @Override
    public int hashCode() {
        return Objects.hash(orderNumber, legalDocRef, ownerDocRef, dueDate, creditDate, dueAmount, status, comments);
    }

    @Override
    public String toString() {
        return "OdcePaymentStatusInfo [" +
                ((orderNumber != null) ? "orderNumber='" + orderNumber + "', " : "") +
                ((legalDocRef != null) ? "legalDocRef='" + legalDocRef + "', " : "") +
                ((ownerDocRef != null) ? "ownerDocRef='" + ownerDocRef + "', " : "") +
                ((dueDate != null) ? "dueDate=" + dueDate + ", " : "") +
                ((creditDate != null) ? "creditDate=" + creditDate + ", " : "") +
                ((dueAmount != null) ? "dueAmount=" + dueAmount + ", " : "") +
                ((status != null) ? "status='" + status + "', " : "") +
                ((comments != null) ? "comments='" + comments + "', " : "") +
                "]";
    }
}