package ar.com.sdd.odceapi.client.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class OdcePaymentStatusInfo implements Serializable {

    private String orderNumber;
    private String trackingNumber;
    private String eventType;
    private String eventMessage;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date eventDate;
    private String paymentCurrency;
    private BigDecimal paymentAmount;

    public OdcePaymentStatusInfo() {
    }

    public String getOrderNumber() {
        return orderNumber;
    }

    public void setOrderNumber(String orderNumber) {
        this.orderNumber = orderNumber;
    }

    public String getTrackingNumber() {
        return trackingNumber;
    }

    public void setTrackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
    }

    public String getEventType() {
        return eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public String getEventMessage() {
        return eventMessage;
    }

    public void setEventMessage(String eventMessage) {
        this.eventMessage = eventMessage;
    }

    public Date getEventDate() {
        return eventDate;
    }

    public void setEventDate(Date eventDate) {
        this.eventDate = eventDate;
    }

    public String getPaymentCurrency() {
        return paymentCurrency;
    }

    public void setPaymentCurrency(String paymentCurrency) {
        this.paymentCurrency = paymentCurrency;
    }

    public BigDecimal getPaymentAmount() {
        return paymentAmount;
    }

    public void setPaymentAmount(BigDecimal paymentAmount) {
        this.paymentAmount = paymentAmount;
    }

    @Override
    public String toString() {
        return "OdcePaymentStatusInfo [" +
                ((orderNumber != null) ? "orderNumber='" + orderNumber + "', " : "") +
                ((trackingNumber != null) ? "trackingNumber='" + trackingNumber + "', " : "") +
                ((eventType != null) ? "eventType='" + eventType + "', " : "") +
                ((eventMessage != null) ? "eventMessage='" + eventMessage + "', " : "") +
                ((eventDate != null) ? "eventDate=" + eventDate + ", " : "") +
                ((paymentCurrency != null) ? "paymentCurrency='" + paymentCurrency + "', " : "") +
                ((paymentAmount != null) ? "paymentAmount=" + paymentAmount + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        OdcePaymentStatusInfo that = (OdcePaymentStatusInfo) o;
        return Objects.equals(orderNumber, that.orderNumber) && Objects.equals(trackingNumber, that.trackingNumber) && Objects.equals(eventType, that.eventType) && Objects.equals(eventMessage, that.eventMessage) && Objects.equals(eventDate, that.eventDate) && Objects.equals(paymentCurrency, that.paymentCurrency) && Objects.equals(paymentAmount, that.paymentAmount);
    }

    @Override
    public int hashCode() {
        return Objects.hash(orderNumber, trackingNumber, eventType, eventMessage, eventDate, paymentCurrency, paymentAmount);
    }
}