/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.odceapi.client.core;

import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.odceapi.client.core.OdceApiConnectorContext;
import ar.com.sdd.odceapi.client.model.OdcePaymentStatusInfo;
import ar.com.sdd.odceapi.client.model.PostPaymentStatusUpdateResponse;
import javax.ws.rs.client.Invocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OdceApiConnector
implements RestSecurityManager {
    private static final Logger log = LogManager.getLogger(OdceApiConnector.class);
    protected final RestConnector restConnector;
    private final String apiKey;

    public OdceApiConnector(OdceApiConnectorContext context) {
        this.apiKey = context.getApiKey();
        log.debug("Creando PatagoniaApiConnector con {}", (Object)context);
        RestConnectorEnvironment environment = new RestConnectorEnvironment(context.getBaseUrl());
        this.restConnector = new RestConnector(environment, (RestSecurityManager)this);
    }

    public PostPaymentStatusUpdateResponse postPaymentStatusUpdate(OdcePaymentStatusInfo odcePaymentStatusInfo) throws RestConnectorException {
        String path = "/sdd";
        log.debug("[postPaymentStatusUpdate] Por notificar cambio de estado de un pago con path [{}] y {}", (Object)path, (Object)odcePaymentStatusInfo);
        return (PostPaymentStatusUpdateResponse)this.restConnector.genericPost((Object)odcePaymentStatusInfo, PostPaymentStatusUpdateResponse.class, PostPaymentStatusUpdateResponse.class, path);
    }

    public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
        if (builder != null) {
            builder.header("api-key", (Object)this.apiKey);
        }
        return builder;
    }

    public boolean retryOnUnauthorized() {
        return false;
    }

    public boolean getDisableHTTPSErrors() {
        return false;
    }
}

