package ar.com.sdd.odceapi.client.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;

@SuppressWarnings("unused")
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class OdceDocument implements Serializable {

    //Datos recibidos en publicacion
    private String ownerType;
    private String ownerCode;
    private String payerCuit;
    private String payerCode;
    private String shiptoCode;
    private String ownerDocRef;
    private String legalDocRef;
    private String operatorEmail;
    private String operatorName;
    private String userType; //Tipo de operador:
    private String currency;
    private BigDecimal totalAmount;
    private BigDecimal dueAmount;
    private BigDecimal totalAmountUSD;
    private BigDecimal dueAmountUSD;
    private BigDecimal dueAmountRate;
    private String comments;
    private String accountCode;
    private String specialGL;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date issueDate;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date dueDate;
    private String assignmentNumber;
    private String businessArea;
    private String division;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date  clearingDate;
    private String salesGroup;
    private String profitCenter;
    private String riskCategory;
    private String authorizationGroup;
    private String salesOrganization;
    private String distributionChannel;
    //Para devolver info
    private String status;
    private String orderNumber;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date creditDate;
    private String collectorBank;
    private String issuerBank;
    private String installmentPlan;
    private String attachLink;

    public String getOwnerType() {
        return ownerType;
    }

    public void setOwnerType(String ownerType) {
        this.ownerType = ownerType;
    }

    public String getOwnerCode() {
        return ownerCode;
    }

    public void setOwnerCode(String ownerCode) {
        this.ownerCode = ownerCode;
    }

    public String getPayerCuit() {
        return payerCuit;
    }

    public void setPayerCuit(String payerCuit) {
        this.payerCuit = payerCuit;
    }

    public String getPayerCode() {
        return payerCode;
    }

    public void setPayerCode(String payerCode) {
        this.payerCode = payerCode;
    }

    public String getShiptoCode() {
        return shiptoCode;
    }

    public void setShiptoCode(String shiptoCode) {
        this.shiptoCode = shiptoCode;
    }

    public String getOwnerDocRef() {
        return ownerDocRef;
    }

    public void setOwnerDocRef(String ownerDocRef) {
        this.ownerDocRef = ownerDocRef;
    }

    public String getLegalDocRef() {
        return legalDocRef;
    }

    public void setLegalDocRef(String legalDocRef) {
        this.legalDocRef = legalDocRef;
    }

    public String getOperatorEmail() {
        return operatorEmail;
    }

    public void setOperatorEmail(String operatorEmail) {
        this.operatorEmail = operatorEmail;
    }

    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public String getUserType() {
        return userType;
    }

    public void setUserType(String userType) {
        this.userType = userType;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public BigDecimal getDueAmount() {
        return dueAmount;
    }

    public void setDueAmount(BigDecimal dueAmount) {
        this.dueAmount = dueAmount;
    }

    public BigDecimal getTotalAmountUSD() {
        return totalAmountUSD;
    }

    public void setTotalAmountUSD(BigDecimal totalAmountUSD) {
        this.totalAmountUSD = totalAmountUSD;
    }

    public BigDecimal getDueAmountUSD() {
        return dueAmountUSD;
    }

    public void setDueAmountUSD(BigDecimal dueAmountUSD) {
        this.dueAmountUSD = dueAmountUSD;
    }

    public BigDecimal getDueAmountRate() {
        return dueAmountRate;
    }

    public void setDueAmountRate(BigDecimal dueAmountRate) {
        this.dueAmountRate = dueAmountRate;
    }

    public String getComments() {
        return comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public String getAccountCode() {
        return accountCode;
    }

    public void setAccountCode(String accountCode) {
        this.accountCode = accountCode;
    }

    public String getSpecialGL() {
        return specialGL;
    }

    public void setSpecialGL(String specialGL) {
        this.specialGL = specialGL;
    }

    public Date getIssueDate() {
        return issueDate;
    }

    public void setIssueDate(Date issueDate) {
        this.issueDate = issueDate;
    }

    public Date getDueDate() {
        return dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public String getAssignmentNumber() {
        return assignmentNumber;
    }

    public void setAssignmentNumber(String assignmentNumber) {
        this.assignmentNumber = assignmentNumber;
    }

    public String getBusinessArea() {
        return businessArea;
    }

    public void setBusinessArea(String businessArea) {
        this.businessArea = businessArea;
    }

    public String getDivision() {
        return division;
    }

    public void setDivision(String division) {
        this.division = division;
    }

    public Date getClearingDate() {
        return clearingDate;
    }

    public void setClearingDate(Date clearingDate) {
        this.clearingDate = clearingDate;
    }

    public String getSalesGroup() {
        return salesGroup;
    }

    public void setSalesGroup(String salesGroup) {
        this.salesGroup = salesGroup;
    }

    public String getProfitCenter() {
        return profitCenter;
    }

    public void setProfitCenter(String profitCenter) {
        this.profitCenter = profitCenter;
    }

    public String getRiskCategory() {
        return riskCategory;
    }

    public void setRiskCategory(String riskCategory) {
        this.riskCategory = riskCategory;
    }

    public String getAuthorizationGroup() {
        return authorizationGroup;
    }

    public void setAuthorizationGroup(String authorizationGroup) {
        this.authorizationGroup = authorizationGroup;
    }

    public String getSalesOrganization() {
        return salesOrganization;
    }

    public void setSalesOrganization(String salesOrganization) {
        this.salesOrganization = salesOrganization;
    }

    public String getDistributionChannel() {
        return distributionChannel;
    }

    public void setDistributionChannel(String distributionChannel) {
        this.distributionChannel = distributionChannel;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getOrderNumber() {
        return orderNumber;
    }

    public void setOrderNumber(String orderNumber) {
        this.orderNumber = orderNumber;
    }

    public Date getCreditDate() {
        return creditDate;
    }

    public void setCreditDate(Date creditDate) {
        this.creditDate = creditDate;
    }

    public String getCollectorBank() {
        return collectorBank;
    }

    public void setCollectorBank(String collectorBank) {
        this.collectorBank = collectorBank;
    }

    public String getIssuerBank() {
        return issuerBank;
    }

    public void setIssuerBank(String issuerBank) {
        this.issuerBank = issuerBank;
    }

    public String getInstallmentPlan() {
        return installmentPlan;
    }

    public void setInstallmentPlan(String installmentPlan) {
        this.installmentPlan = installmentPlan;
    }

    public String getAttachLink() {
        return attachLink;
    }

    public void setAttachLink(String attachLink) {
        this.attachLink = attachLink;
    }

    @Override
    public String toString() {
        return "OdceDocument [" +
                ((ownerType != null) ? "ownerType='" + ownerType + "', " : "") +
                ((ownerCode != null) ? "ownerCode='" + ownerCode + "', " : "") +
                ((payerCuit != null) ? "payerCuit='" + payerCuit + "', " : "") +
                ((payerCode != null) ? "payerCode='" + payerCode + "', " : "") +
                ((shiptoCode != null) ? "shiptoCode='" + shiptoCode + "', " : "") +
                ((ownerDocRef != null) ? "ownerDocRef='" + ownerDocRef + "', " : "") +
                ((legalDocRef != null) ? "legalDocRef='" + legalDocRef + "', " : "") +
                ((operatorEmail != null) ? "operatorEmail='" + operatorEmail + "', " : "") +
                ((operatorName != null) ? "operatorName='" + operatorName + "', " : "") +
                ((userType != null) ? "userType='" + userType + "', " : "") +
                ((currency != null) ? "currency='" + currency + "', " : "") +
                ((totalAmount != null) ? "totalAmount=" + totalAmount + ", " : "") +
                ((dueAmount != null) ? "dueAmount=" + dueAmount + ", " : "") +
                ((totalAmountUSD != null) ? "totalAmountUSD=" + totalAmountUSD + ", " : "") +
                ((dueAmountUSD != null) ? "dueAmountUSD=" + dueAmountUSD + ", " : "") +
                ((dueAmountRate != null) ? "dueAmountRate=" + dueAmountRate + ", " : "") +
                ((comments != null) ? "comments='" + comments + "', " : "") +
                ((accountCode != null) ? "accountCode='" + accountCode + "', " : "") +
                ((specialGL != null) ? "specialGL='" + specialGL + "', " : "") +
                ((issueDate != null) ? "issueDate=" + issueDate + ", " : "") +
                ((dueDate != null) ? "dueDate=" + dueDate + ", " : "") +
                ((assignmentNumber != null) ? "assignmentNumber='" + assignmentNumber + "', " : "") +
                ((businessArea != null) ? "businessArea='" + businessArea + "', " : "") +
                ((division != null) ? "division='" + division + "', " : "") +
                ((clearingDate != null) ? "clearingDate=" + clearingDate + ", " : "") +
                ((salesGroup != null) ? "salesGroup='" + salesGroup + "', " : "") +
                ((profitCenter != null) ? "profitCenter='" + profitCenter + "', " : "") +
                ((riskCategory != null) ? "riskCategory='" + riskCategory + "', " : "") +
                ((authorizationGroup != null) ? "authorizationGroup='" + authorizationGroup + "', " : "") +
                ((salesOrganization != null) ? "salesOrganization='" + salesOrganization + "', " : "") +
                ((distributionChannel != null) ? "distributionChannel='" + distributionChannel + "', " : "") +
                ((status != null) ? "status='" + status + "', " : "") +
                ((orderNumber != null) ? "orderNumber='" + orderNumber + "', " : "") +
                ((creditDate != null) ? "creditDate=" + creditDate + ", " : "") +
                ((collectorBank != null) ? "collectorBank='" + collectorBank + "', " : "") +
                ((issuerBank != null) ? "issuerBank='" + issuerBank + "', " : "") +
                ((installmentPlan != null) ? "installmentPlan='" + installmentPlan + "', " : "") +
                ((attachLink != null) ? "attachLink='" + attachLink + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        OdceDocument that = (OdceDocument) o;
        return Objects.equals(ownerType, that.ownerType) && Objects.equals(ownerCode, that.ownerCode) && Objects.equals(payerCuit, that.payerCuit) && Objects.equals(payerCode, that.payerCode) && Objects.equals(shiptoCode, that.shiptoCode) && Objects.equals(ownerDocRef, that.ownerDocRef) && Objects.equals(legalDocRef, that.legalDocRef) && Objects.equals(operatorEmail, that.operatorEmail) && Objects.equals(operatorName, that.operatorName) && Objects.equals(userType, that.userType) && Objects.equals(currency, that.currency) && Objects.equals(totalAmount, that.totalAmount) && Objects.equals(dueAmount, that.dueAmount) && Objects.equals(totalAmountUSD, that.totalAmountUSD) && Objects.equals(dueAmountUSD, that.dueAmountUSD) && Objects.equals(dueAmountRate, that.dueAmountRate) && Objects.equals(comments, that.comments) && Objects.equals(accountCode, that.accountCode) && Objects.equals(specialGL, that.specialGL) && Objects.equals(issueDate, that.issueDate) && Objects.equals(dueDate, that.dueDate) && Objects.equals(assignmentNumber, that.assignmentNumber) && Objects.equals(businessArea, that.businessArea) && Objects.equals(division, that.division) && Objects.equals(clearingDate, that.clearingDate) && Objects.equals(salesGroup, that.salesGroup) && Objects.equals(profitCenter, that.profitCenter) && Objects.equals(riskCategory, that.riskCategory) && Objects.equals(authorizationGroup, that.authorizationGroup) && Objects.equals(salesOrganization, that.salesOrganization) && Objects.equals(distributionChannel, that.distributionChannel) && Objects.equals(status, that.status) && Objects.equals(orderNumber, that.orderNumber) && Objects.equals(creditDate, that.creditDate) && Objects.equals(collectorBank, that.collectorBank) && Objects.equals(issuerBank, that.issuerBank) && Objects.equals(installmentPlan, that.installmentPlan) && Objects.equals(attachLink, that.attachLink);
    }

    @Override
    public int hashCode() {
        return Objects.hash(ownerType, ownerCode, payerCuit, payerCode, shiptoCode, ownerDocRef, legalDocRef, operatorEmail, operatorName, userType, currency, totalAmount, dueAmount, totalAmountUSD, dueAmountUSD, dueAmountRate, comments, accountCode, specialGL, issueDate, dueDate, assignmentNumber, businessArea, division, clearingDate, salesGroup, profitCenter, riskCategory, authorizationGroup, salesOrganization, distributionChannel, status, orderNumber, creditDate, collectorBank, issuerBank, installmentPlan, attachLink);
    }
}