package ar.com.sdd.odceapi.client.core;

import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.odceapi.client.model.OdcePaymentStatusInfo;
import ar.com.sdd.odceapi.client.model.PostPaymentStatusUpdateRequest;
import ar.com.sdd.odceapi.client.model.PostPaymentStatusUpdateResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import javax.ws.rs.client.Invocation;

public class OdceApiConnector implements RestSecurityManager {

    private final static Logger log = LogManager.getLogger(OdceApiConnector.class);

    protected final RestConnector restConnector;
    private final String apiKey;

    public OdceApiConnector(OdceApiConnectorContext context) {
        this.apiKey = context.getApiKey();

        log.debug("Creando OdceApiConnector con {}", context);
        RestConnectorEnvironment environment = new RestConnectorEnvironment(context.getBaseUrl());
        restConnector = new RestConnector(environment, this);
    }

    public PostPaymentStatusUpdateResponse postPaymentStatusUpdate(PostPaymentStatusUpdateRequest postPaymentStatusUpdateRequest) throws RestConnectorException {
        String path = "/sdd";
        log.debug("[postPaymentStatusUpdate] Por notificar cambio de estado de un pago con path [{}] y {}", path, postPaymentStatusUpdateRequest);
        return restConnector.genericPost(postPaymentStatusUpdateRequest, PostPaymentStatusUpdateResponse.class, PostPaymentStatusUpdateResponse.class, path);
    }

    @SuppressWarnings("RedundantThrows")
    @Override
    public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
        if (builder != null) {
            builder.header("api-key", apiKey);
        }
        return builder;
    }

    @Override
    public boolean retryOnUnauthorized() {
        return false;
    }

    @Override
    public boolean getDisableHTTPSErrors() {
        return false;
    }
}