/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.odceapi.api.payment;

import ar.com.sdd.commons.rest.log.ServerFileLogged;
import ar.com.sdd.odceapi.api.payment.OdcePaymentApiService;
import ar.com.sdd.odceapi.client.model.OdceDocument;
import ar.com.sdd.odceapi.client.model.OdceDocumentSet;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path(value="/odce-api/v1_0/payment")
public class OdcePaymentApiEndpoint {
    @Inject
    private OdcePaymentApiService paymentApiService;

    @POST
    @ServerFileLogged
    @Path(value="/aid/{aid}/owner/{ownerId}/document-set/payment-link")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json; charset=utf-8"})
    public Response postDocumentSetPaymentLink(@HeaderParam(value="Authorization") String authorization, @PathParam(value="aid") String applicationId, @PathParam(value="ownerId") String ownerId, OdceDocumentSet documentSet, @Context SecurityContext securityContext) {
        return this.paymentApiService.postDocumentSetPaymentLink(authorization, applicationId, ownerId, documentSet, securityContext);
    }

    @GET
    @ServerFileLogged
    @Path(value="/aid/{aid}/owner/{ownerId}/payments")
    @Produces(value={"application/json; charset=utf-8"})
    public Response getPayments(@HeaderParam(value="Authorization") String authorization, @PathParam(value="aid") String applicationId, @PathParam(value="ownerId") String ownerId, @QueryParam(value="fromCreationDate") String fromCreationDate, @QueryParam(value="toCreationDate") String toCreationDate, @QueryParam(value="ownerDocRefList") String ownerDocRefList, @QueryParam(value="legalDocRefList") String legalDocRefList, @Context SecurityContext securityContext) {
        return this.paymentApiService.getPayments(authorization, applicationId, ownerId, fromCreationDate, toCreationDate, ownerDocRefList, legalDocRefList, securityContext);
    }

    @GET
    @ServerFileLogged
    @Path(value="/aid/{aid}/owner/{ownerId}/payment-status-info/orderNumber/{orderNumber}")
    @Produces(value={"application/json; charset=utf-8"})
    public Response getPaymentStatusInfo(@HeaderParam(value="Authorization") String authorization, @PathParam(value="aid") String applicationId, @PathParam(value="ownerId") String ownerId, @PathParam(value="orderNumber") String orderNumber, @Context SecurityContext securityContext) {
        return this.paymentApiService.getPaymentStatusInfo(authorization, applicationId, ownerId, orderNumber, securityContext);
    }

    @GET
    @ServerFileLogged
    @Path(value="/aid/{aid}/owner/{ownerId}/documentAttach/orderNumber/{orderNumber}/attach-link")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json; charset=utf-8"})
    public Response getDocumentAttachLink(@HeaderParam(value="Authorization") String authorization, @PathParam(value="aid") String applicationId, @PathParam(value="ownerId") String ownerId, @PathParam(value="orderNumber") String orderNumber, @Context SecurityContext securityContext) {
        return this.paymentApiService.getDocumentAttachLink(authorization, applicationId, ownerId, orderNumber, securityContext);
    }

    @POST
    @ServerFileLogged
    @Path(value="/aid/{aid}/owner/{ownerId}/instrument")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json; charset=utf-8"})
    public Response postInstrument(@HeaderParam(value="Authorization") String authorization, @PathParam(value="aid") String applicationId, @PathParam(value="ownerId") String ownerId, OdceDocument instrument, @Context SecurityContext securityContext) {
        return this.paymentApiService.postInstrument(authorization, applicationId, ownerId, instrument, securityContext);
    }
}

