package ar.com.sdd.odceapi.api.payment;

import ar.com.sdd.odceapi.client.model.OdceDocument;
import ar.com.sdd.odceapi.client.model.OdceDocumentSet;

import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

public interface OdcePaymentApiService {

    /**
     * Arma una orden de pago a partir de los documentos pasados dentro del {@link ar.com.sdd.odceapi.client.model.OdceDocumentSet#getDocuments()} y devuelve un link hacia la OP creada.
     * Si los documentos no son PACs, antes de crear la OP los publica en la plataforma
     * Si ya existe la OP, devuelve el link hacia la misma
     *
     * @return {@link ar.com.sdd.odceapi.client.model.OdcePaymentLink}
     */
    Response postDocumentSetPaymentLink(String authorization, String applicationId, String ownerId, OdceDocumentSet documentSet, SecurityContext securityContext);

    /**
     * Busca pagos de un por rango de fechas o referencias
     *
     * @return Collection&lt;{@link ar.com.sdd.odceapi.client.model.OdcePayment}&gt;
     */
    Response getPayments(String authorization, String applicationId, String ownerId, String fromCreationDate, String toCreationDate, String ownerDocRefList, String legalDocRefList, Integer offset, Integer limit, SecurityContext securityContext);

    /**
     * Consulta status mas conciso de un orderNumber: status, fecha, xx
     *
     * @return {@link ar.com.sdd.odceapi.client.model.OdcePaymentStatusInfo}
     */
    Response getPaymentStatusInfo(String authorization, String applicationId, String ownerId, String orderNumber, SecurityContext securityContext);

    /**
     * Dado un orderNumber, obtiene un link a un PDF asociado
     *
     * @return {@link ar.com.sdd.odceapi.client.model.OdcePaymentLink}
     */
    Response getDocumentAttachLink(String authorization, String applicationId, String ownerId, String orderNumber, SecurityContext securityContext);

    /**
     * Publica un intrumento tipo RPG
     *
     * @return {@link ar.com.sdd.odceapi.client.model.OdceDocument}
     */
    Response postInstrument(String authorization, String applicationId, String ownerId, OdceDocument document, SecurityContext securityContext);
}
