package ar.com.sdd.odceapi.api.payment;

import ar.com.sdd.commons.rest.log.ServerFileLogged;
import ar.com.sdd.odceapi.client.model.OdceDocument;
import ar.com.sdd.odceapi.client.model.OdceDocumentSet;

import javax.inject.Inject;
import javax.ws.rs.*;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path("/odce-api/v1_0/payment")
public class OdcePaymentApiEndpoint {

    @Inject private OdcePaymentApiService paymentApiService;

    @POST
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/document-set/payment-link")
    @Consumes({"application/json"})
    @Produces("application/json; charset=utf-8")
    public Response postDocumentSetPaymentLink(@HeaderParam("Authorization") String authorization, @PathParam("aid") String applicationId, @PathParam("ownerId") String ownerId, OdceDocumentSet documentSet, @Context SecurityContext securityContext) {
        return paymentApiService.postDocumentSetPaymentLink(authorization, applicationId, ownerId, documentSet, securityContext);
    }

    @GET
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/payments")
    @Produces("application/json; charset=utf-8")
    public Response getPayments(@HeaderParam("Authorization") String authorization, @PathParam("aid") String applicationId, @PathParam("ownerId") String ownerId,
                                @QueryParam("fromCreationDate") String fromCreationDate,
                                @QueryParam("toCreationDate") String toCreationDate,
                                @QueryParam("ownerDocRefList") String ownerDocRefList,
                                @QueryParam("legalDocRefList") String legalDocRefList,
                                @QueryParam("offset") Integer offset,
                                @QueryParam("limit") Integer limit,
                                @Context SecurityContext securityContext) {
        return paymentApiService.getPayments(authorization, applicationId, ownerId, fromCreationDate, toCreationDate, ownerDocRefList, legalDocRefList, offset, limit, securityContext);
    }

    @GET
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/payment-status-info/orderNumber/{orderNumber}")
    @Produces("application/json; charset=utf-8")
    public Response getPaymentStatusInfo(@HeaderParam("Authorization") String authorization, @PathParam("aid") String applicationId, @PathParam("ownerId") String ownerId,
                               @PathParam("orderNumber") String orderNumber,
                               @Context SecurityContext securityContext) {
        return paymentApiService.getPaymentStatusInfo(authorization, applicationId, ownerId, orderNumber, securityContext);
    }

    @GET
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/documentAttach/orderNumber/{orderNumber}/attach-link")
    @Consumes({"application/json"})
    @Produces("application/json; charset=utf-8")
    public Response getDocumentAttachLink(@HeaderParam("Authorization") String authorization, @PathParam("aid") String applicationId, @PathParam("ownerId") String ownerId,
                                         @PathParam("orderNumber") String orderNumber,
                                         @Context SecurityContext securityContext) {
        return paymentApiService.getDocumentAttachLink(authorization, applicationId, ownerId, orderNumber, securityContext);
    }

    @POST
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/instrument")
    @Consumes({"application/json"})
    @Produces("application/json; charset=utf-8")
    public Response postInstrument(@HeaderParam("Authorization") String authorization, @PathParam("aid") String applicationId, @PathParam("ownerId") String ownerId,
                                  OdceDocument instrument,
                                  @Context SecurityContext securityContext) {
        return paymentApiService.postInstrument(authorization, applicationId, ownerId, instrument, securityContext);
    }

}
