package ar.com.sdd.pagomiscuentasapi.core;

import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.pagomiscuentasapi.io.*;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;

public class PagoMisCuentasApiConnector {

    private static final Logger log = LogManager.getLogger(PagoMisCuentasApiConnector.class);

    private final RestConnector connector;

    private final String baseUrl;

    public PagoMisCuentasApiConnector(PagoMisCuentasApiConnectorContext context) {
        this.baseUrl = context.getBaseUrl();

        log.trace("Creando PagoMisCuentasApiConnector", context);
        RestConnectorEnvironment environment = new RestConnectorEnvironment(context.getBaseUrl());
        connector = new RestConnector(environment, null);
    }

    ///////////////////////// Adhesión de usuario: Attach_invoice /////////////////////////
    public PostResponse postAttachInvoiceResponse(PostAttachInvoiceRequest postAttachInvoiceRequest) throws RestConnectorException {
        final String path = "/attach_invoice";
        log.debug("[postAttachInvoice] Adhiriendo a usuario con path [{}]", path);
        return connector.genericPost(postAttachInvoiceRequest, PostResponse.class, CommonError.class, path);
    }

    ///////////////////////// Alta de factura: Add_invoice /////////////////////////
    public PostResponse postAltaFactura(PostAddInvoiceRequest postAddInvoiceRequest) throws RestConnectorException {
        final String path = "/add_invoice";
        log.debug("[postAltaFactura] Dando de alta factura con path [{}]", path);
        return connector.genericPost(postAddInvoiceRequest, PostResponse.class, CommonError.class, path);
    }

    ///////////////////////// Baja de factura: Remove_invoice /////////////////////////
    public PostResponse postBajaFacturas(PostRemoveInvoiceRequest postRemoveInvoiceRequest) throws RestConnectorException {
        final String path = "/remove_invoice";
        log.debug("[postBajaFacturas] Dando de baja factura con path [{}]", path);
        return connector.genericPost(postRemoveInvoiceRequest, PostResponse.class, CommonError.class, path);
    }

    ///////////////////////// Prueba de conectividad: Echo /////////////////////////
    public GetEchoResponse getEcho(String message) throws RestConnectorException {
        final String path = "/echo/" + message;
        log.debug("[getEcho] Probando conectividad con mensaje [{}] con path [{}]", message, path);
        return connector.genericGet(null, GetEchoResponse.class, CommonError.class, path);
    }

    ///////////////////////// Consulta bancos: Banks /////////////////////////
    public GetBanksResponse getBanks() throws RestConnectorException {
        final String path = "/banks";
        log.debug("[getBanks] Consultando bancos con path [{}]", path);
        return connector.genericGet(null, GetBanksResponse.class, CommonError.class, path);
    }

    ///////////////////////// Consulta tipos de documento: Document_types /////////////////////////
    public GetDocumentTypesResponse getDocumentTypes() throws RestConnectorException {
        final String path = "/document_types";
        log.debug("[getDocumentTypes] Consultando tipos de documento con path [{}]", path);
        return connector.genericGet(null, GetDocumentTypesResponse.class, CommonError.class, path);
    }

}
