package ar.com.sdd.pagomiscuentasapi.io;

import ar.com.sdd.pagomiscuentasapi.model.DocumentType;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class GetDocumentTypesResponse implements Serializable {

    @JsonProperty("document_types")
    private List<DocumentType> documentTypes;

    public List<DocumentType> getDocumentTypes() {
        return documentTypes;
    }

    public void setDocumentTypes(List<DocumentType> documentTypes) {
        this.documentTypes = documentTypes;
    }

    @Override
    public String toString() {
        return "GetDocumentTypesResponse [" +
                ((documentTypes != null) ? "documentTypes=" + Arrays.toString(documentTypes.toArray()) + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GetDocumentTypesResponse that = (GetDocumentTypesResponse) o;
        return Objects.equals(documentTypes, that.documentTypes);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(documentTypes);
    }
}
