package ar.com.sdd.pagomiscuentasapiserver.notify;

import ar.com.sdd.commons.rest.log.ServerFileLogged;
import ar.com.sdd.pagomiscuentasapiserver.notify.io.PagoMisCuentasApiNotifyRequest;

import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

@Path("payment_notify")
public class PagoMisCuentasApiNotifyEndpoint {

    @Inject
    private PagoMisCuentasApiNotifyService notifyService;

    // Endpoint de echo para verificar que el servicio está activo
    @POST
    @ServerFileLogged
    @Consumes(MediaType.APPLICATION_JSON)
    @Produces(MediaType.APPLICATION_JSON)
    public Response postNotification(PagoMisCuentasApiNotifyRequest request) {
        return notifyService.postNotification(request);
    }

}
