package ar.com.sdd.pagomiscuentasapi.io;

import ar.com.sdd.pagomiscuentasapi.model.Bank;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class GetBanksResponse implements Serializable {

    @JsonProperty("banks")
    private List<Bank> banks;

    public List<Bank> getBanks() {
        return banks;
    }

    public void setBanks(List<Bank> banks) {
        this.banks = banks;
    }

    @Override
    public String toString() {
        return "GetBanksResponse [" +
                ((banks != null) ? "banks=" + Arrays.toString(banks.toArray()) + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GetBanksResponse that = (GetBanksResponse) o;
        return Objects.equals(banks, that.banks);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(banks);
    }
}
