package ar.com.sdd.pagomiscuentasapi.io;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class GetEchoResponse implements Serializable {

    @JsonProperty("mensaje")
    private String mensaje;

    @JsonProperty("fecha")
    private String fecha;

    @JsonProperty("duracion")
    private Integer duracion;

    public String getMensaje() {
        return mensaje;
    }

    public void setMensaje(String mensaje) {
        this.mensaje = mensaje;
    }

    public String getFecha() {
        return fecha;
    }

    public void setFecha(String fecha) {
        this.fecha = fecha;
    }

    public Integer getDuracion() {
        return duracion;
    }

    public void setDuracion(Integer duracion) {
        this.duracion = duracion;
    }

    @Override
    public String toString() {
        return "GetEchoResponse [" +
                ((mensaje != null) ? "mensaje='" + mensaje + "', " : "") +
                ((fecha != null) ? "fecha='" + fecha + "', " : "") +
                ((duracion != null) ? "duracion=" + duracion + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GetEchoResponse that = (GetEchoResponse) o;
        return Objects.equals(mensaje, that.mensaje) && Objects.equals(fecha, that.fecha) && Objects.equals(duracion, that.duracion);
    }

    @Override
    public int hashCode() {
        return Objects.hash(mensaje, fecha, duracion);
    }
}
