package ar.com.sdd.pagomiscuentasapi.io;

import ar.com.sdd.pagomiscuentasapi.model.DueDate;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PostAddInvoiceRequest implements Serializable {

    @JsonProperty("company_id")
    private String companyId;

    @JsonProperty("customer_id")
    private String customerId;

    @JsonProperty("invoice_id")
    private String invoiceId;

    @JsonProperty("screen_description")
    private String screenDescription;

    @JsonProperty("invoice_description")
    private String invoiceDescription;

    @JsonProperty("currency")
    private String currency;

    @JsonProperty("due_dates")
    private List<DueDate> dueDates;

    @Override
    public String toString() {
        return "PostAddInvoiceRequest [" +
                ((companyId != null) ? "companyId='" + companyId + "', " : "") +
                ((customerId != null) ? "customerId='" + customerId + "', " : "") +
                ((invoiceId != null) ? "invoiceId='" + invoiceId + "', " : "") +
                ((screenDescription != null) ? "screenDescription='" + screenDescription + "', " : "") +
                ((invoiceDescription != null) ? "invoiceDescription='" + invoiceDescription + "', " : "") +
                ((currency != null) ? "currency='" + currency + "', " : "") +
                ((dueDates != null) ? "dueDates=" + Arrays.toString(dueDates.toArray()) + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PostAddInvoiceRequest that = (PostAddInvoiceRequest) o;
        return Objects.equals(companyId, that.companyId) && Objects.equals(customerId, that.customerId) && Objects.equals(invoiceId, that.invoiceId) && Objects.equals(screenDescription, that.screenDescription) && Objects.equals(invoiceDescription, that.invoiceDescription) && Objects.equals(currency, that.currency) && Objects.equals(dueDates, that.dueDates);
    }

    @Override
    public int hashCode() {
        return Objects.hash(companyId, customerId, invoiceId, screenDescription, invoiceDescription, currency, dueDates);
    }
}
