package ar.com.sdd.pagomiscuentasapi.io;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PostAttachInvoiceRequest implements Serializable {

    @JsonProperty("company_id")
    private String companyId;

    @JsonProperty("bank_id")
    private String bankId;

    @JsonProperty("document_type_id")
    private String documentTypeId;

    @JsonProperty("document_type_description")
    private String documentTypeDescription;

    @JsonProperty("document_number")
    private String documentNumber;

    @JsonProperty("customer_id")
    private String customerId;

    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }

    public String getBankId() {
        return bankId;
    }

    public void setBankId(String bankId) {
        this.bankId = bankId;
    }

    public String getDocumentTypeId() {
        return documentTypeId;
    }

    public void setDocumentTypeId(String documentTypeId) {
        this.documentTypeId = documentTypeId;
    }

    public String getDocumentTypeDescription() {
        return documentTypeDescription;
    }

    public void setDocumentTypeDescription(String documentTypeDescription) {
        this.documentTypeDescription = documentTypeDescription;
    }

    public String getDocumentNumber() {
        return documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public String getCustomerId() {
        return customerId;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    @Override
    public String toString() {
        return "PostAttachInvoiceRequest [" +
                ((companyId != null) ? "companyId='" + companyId + "', " : "") +
                ((bankId != null) ? "bankId='" + bankId + "', " : "") +
                ((documentTypeId != null) ? "documentTypeId='" + documentTypeId + "', " : "") +
                ((documentTypeDescription != null) ? "documentTypeDescription='" + documentTypeDescription + "', " : "") +
                ((documentNumber != null) ? "documentNumber='" + documentNumber + "', " : "") +
                ((customerId != null) ? "customerId='" + customerId + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PostAttachInvoiceRequest that = (PostAttachInvoiceRequest) o;
        return Objects.equals(companyId, that.companyId) && Objects.equals(bankId, that.bankId) && Objects.equals(documentTypeId, that.documentTypeId) && Objects.equals(documentTypeDescription, that.documentTypeDescription) && Objects.equals(documentNumber, that.documentNumber) && Objects.equals(customerId, that.customerId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(companyId, bankId, documentTypeId, documentTypeDescription, documentNumber, customerId);
    }
}
