package ar.com.sdd.pagomiscuentasapi.io;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PostRemoveInvoiceRequest implements Serializable{

    @JsonProperty("company_id")
    private String companyId;

    @JsonProperty("customer_id")
    private String customerId;

    @JsonProperty("invoice_id")
    private String invoiceId;

    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }

    public String getCustomerId() {
        return customerId;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public String getInvoiceId() {
        return invoiceId;
    }

    public void setInvoiceId(String invoiceId) {
        this.invoiceId = invoiceId;
    }

    @Override
    public String toString() {
        return "PostRemoveInvoiceRequest [" +
                ((companyId != null) ? "companyId='" + companyId + "', " : "") +
                ((customerId != null) ? "customerId='" + customerId + "', " : "") +
                ((invoiceId != null) ? "invoiceId='" + invoiceId + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PostRemoveInvoiceRequest that = (PostRemoveInvoiceRequest) o;
        return Objects.equals(companyId, that.companyId) && Objects.equals(customerId, that.customerId) && Objects.equals(invoiceId, that.invoiceId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(companyId, customerId, invoiceId);
    }
}
