package ar.com.sdd.pagomiscuentasapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Bank implements Serializable {

    @JsonProperty("name")
    private String name;

    @JsonProperty("bank_id")
    private String bankId;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getBankId() {
        return bankId;
    }

    public void setBankId(String bankId) {
        this.bankId = bankId;
    }

    @Override
    public String toString() {
        return "Bank [" +
                ((name != null) ? "name='" + name + "', " : "") +
                ((bankId != null) ? "bankId='" + bankId + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Bank bank = (Bank) o;
        return Objects.equals(name, bank.name) && Objects.equals(bankId, bank.bankId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, bankId);
    }
}
