package ar.com.sdd.pagomiscuentasapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class DueDate implements Serializable {

    @JsonProperty("due_date")
    private String dueDate;

    @JsonProperty("due_date_hour")
    private String dueDateHour;

    @JsonProperty("amount")
    private Integer amount;

    public String getDueDate() {
        return dueDate;
    }

    public void setDueDate(String dueDate) {
        this.dueDate = dueDate;
    }

    public String getDueDateHour() {
        return dueDateHour;
    }

    public void setDueDateHour(String dueDateHour) {
        this.dueDateHour = dueDateHour;
    }

    public Integer getAmount() {
        return amount;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    @Override
    public String toString() {
        return "DueDate [" +
                ((dueDate != null) ? "dueDate='" + dueDate + "', " : "") +
                ((dueDateHour != null) ? "dueDateHour='" + dueDateHour + "', " : "") +
                ((amount != null) ? "amount=" + amount + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DueDate dueDate1 = (DueDate) o;
        return Objects.equals(dueDate, dueDate1.dueDate) && Objects.equals(dueDateHour, dueDate1.dueDateHour) && Objects.equals(amount, dueDate1.amount);
    }

    @Override
    public int hashCode() {
        return Objects.hash(dueDate, dueDateHour, amount);
    }
}
