package ar.com.sdd.pagomiscuentasapiserver.echo;

import ar.com.sdd.commons.rest.log.ServerFileLogged;

import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

@Path("/echo")
public class PagoMisCuentasApiEchoEndpoint {

    @Inject
    private PagoMisCuentasApiEchoService echoService;

    // Endpoint de echo para verificar que el servicio está activo
    @GET
    @ServerFileLogged
    @Consumes(MediaType.APPLICATION_JSON)
    @Produces(MediaType.APPLICATION_JSON)
    public Response getEcho(String token) {
        return echoService.getEcho(token);
    }

}
