/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.pagomiscuentasapi.core;

import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.pagomiscuentasapi.core.PagoMisCuentasApiConnectorContext;
import ar.com.sdd.pagomiscuentasapi.io.CommonError;
import ar.com.sdd.pagomiscuentasapi.io.GetBanksResponse;
import ar.com.sdd.pagomiscuentasapi.io.GetDocumentTypesResponse;
import ar.com.sdd.pagomiscuentasapi.io.GetEchoResponse;
import ar.com.sdd.pagomiscuentasapi.io.PostAddInvoiceRequest;
import ar.com.sdd.pagomiscuentasapi.io.PostAttachInvoiceRequest;
import ar.com.sdd.pagomiscuentasapi.io.PostRemoveInvoiceRequest;
import ar.com.sdd.pagomiscuentasapi.io.PostResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PagoMisCuentasApiConnector {
    private static final Logger log = LogManager.getLogger(PagoMisCuentasApiConnector.class);
    private final RestConnector connector;
    private final String baseUrl;

    public PagoMisCuentasApiConnector(PagoMisCuentasApiConnectorContext context) {
        this.baseUrl = context.getBaseUrl();
        log.trace("Creando PagoMisCuentasApiConnector", (Object)context);
        RestConnectorEnvironment environment = new RestConnectorEnvironment(context.getBaseUrl());
        this.connector = new RestConnector(environment, null);
    }

    public PostResponse postAttachInvoiceResponse(PostAttachInvoiceRequest postAttachInvoiceRequest) throws RestConnectorException {
        String path = "/attach_invoice";
        log.debug("[postAttachInvoice] Adhiriendo a usuario con path [{}]", (Object)"/attach_invoice");
        return (PostResponse)this.connector.genericPost((Object)postAttachInvoiceRequest, PostResponse.class, CommonError.class, "/attach_invoice");
    }

    public PostResponse postAltaFactura(PostAddInvoiceRequest postAddInvoiceRequest) throws RestConnectorException {
        String path = "/add_invoice";
        log.debug("[postAltaFactura] Dando de alta factura con path [{}]", (Object)"/add_invoice");
        return (PostResponse)this.connector.genericPost((Object)postAddInvoiceRequest, PostResponse.class, CommonError.class, "/add_invoice");
    }

    public PostResponse postBajaFacturas(PostRemoveInvoiceRequest postRemoveInvoiceRequest) throws RestConnectorException {
        String path = "/remove_invoice";
        log.debug("[postBajaFacturas] Dando de baja factura con path [{}]", (Object)"/remove_invoice");
        return (PostResponse)this.connector.genericPost((Object)postRemoveInvoiceRequest, PostResponse.class, CommonError.class, "/remove_invoice");
    }

    public GetEchoResponse getEcho(String message) throws RestConnectorException {
        String path = "/echo/" + message;
        log.debug("[getEcho] Probando conectividad con mensaje [{}] con path [{}]", (Object)message, (Object)path);
        return (GetEchoResponse)this.connector.genericGet(null, GetEchoResponse.class, CommonError.class, path);
    }

    public GetBanksResponse getBanks() throws RestConnectorException {
        String path = "/banks";
        log.debug("[getBanks] Consultando bancos con path [{}]", (Object)"/banks");
        return (GetBanksResponse)this.connector.genericGet(null, GetBanksResponse.class, CommonError.class, "/banks");
    }

    public GetDocumentTypesResponse getDocumentTypes() throws RestConnectorException {
        String path = "/document_types";
        log.debug("[getDocumentTypes] Consultando tipos de documento con path [{}]", (Object)"/document_types");
        return (GetDocumentTypesResponse)this.connector.genericGet(null, GetDocumentTypesResponse.class, CommonError.class, "/document_types");
    }
}

