package ar.com.sdd.patagoniaapi.io;

import ar.com.sdd.patagoniaapi.model.Empresa;
import ar.com.sdd.patagoniaapi.model.Usuario;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class LoginResponse implements Serializable {

    @JsonProperty("usuario")
    private Usuario usuario;

    @JsonProperty("estadoEjecucion")
    private String estadoEjecucion;

    public Usuario getUsuario() {
        return usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    public String getString() {
        return estadoEjecucion;
    }

    public void setString(String estadoEjecucion) {
        this.estadoEjecucion = estadoEjecucion;
    }

    @Override
    public String toString() {
        return "LoginRequest{" +
                "usuario=" + usuario +
                ", estadoEjecucion=" + estadoEjecucion +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        LoginResponse that = (LoginResponse) o;
        return Objects.equals(usuario, that.usuario) && Objects.equals(estadoEjecucion, that.estadoEjecucion);
    }

    @Override
    public int hashCode() {
        return Objects.hash(usuario, estadoEjecucion);
    }
}