/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.patagoniaapi.core;

import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.patagoniaapi.core.PatagoniaApiConnectorContext;
import ar.com.sdd.patagoniaapi.io.LoginRequest;
import ar.com.sdd.patagoniaapi.io.LoginResponse;
import ar.com.sdd.patagoniaapi.model.Documento;
import ar.com.sdd.patagoniaapi.model.Empresa;
import ar.com.sdd.patagoniaapi.model.Usuario;
import ar.com.sdd.patagoniaapi.util.SimpleCache;
import java.time.temporal.ChronoUnit;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.log4j.Logger;

public class PatagoniaApiConnector
implements RestSecurityManager {
    private static final Logger log = Logger.getLogger(PatagoniaApiConnector.class);
    private final RestConnector restConnector;
    private final String GET_TOKEN_URL = "https://no-prod-api.bancopatagonia.com.ar/qa/empresas/v2/login/ch/BP";
    private final String baseUrl;
    private final String xUid;
    private final String usuarioAlias;
    private final String documentoTipo;
    private final String documentoNumero;
    private final SimpleCache<String, String> cache;

    public PatagoniaApiConnector(PatagoniaApiConnectorContext context) {
        this.baseUrl = context.getBaseUrl();
        this.xUid = context.getXUid();
        this.usuarioAlias = context.getUsuarioAlias();
        this.documentoTipo = context.getDocumentoTipo();
        this.documentoNumero = context.getDocumentoNumero();
        log.debug((Object)("Creando PatagoniaApiConnector con " + context));
        RestConnectorEnvironment environment = new RestConnectorEnvironment(this.baseUrl);
        this.restConnector = new RestConnector(environment, (RestSecurityManager)this);
        this.cache = SimpleCache.builder().maximumSize(1L).expireAfter(3599L, ChronoUnit.MINUTES).build();
    }

    public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
        if (builder != null) {
            builder.header("x-uid", (Object)this.xUid);
            builder.header("", (Object)this.getAccessToken());
        }
        return builder;
    }

    public boolean getDisableHTTPSErrors() {
        return false;
    }

    public String getAccessToken() throws RestConnectorException {
        String accessToken = this.cache.getIfPresent("accessToken");
        if (accessToken == null) {
            Usuario usuario = new Usuario();
            usuario.setAlias(this.usuarioAlias);
            Documento documento = new Documento();
            documento.setTipo(this.documentoTipo);
            documento.setNumero(this.documentoNumero);
            Empresa empresa = new Empresa();
            empresa.setDocumento(documento);
            LoginRequest request = new LoginRequest();
            request.setUsuario(usuario);
            log.debug((Object)("[getAccessToken] Por recuperar token con [" + request + "]"));
            RestConnector connector = new RestConnector(new RestConnectorEnvironment("https://no-prod-api.bancopatagonia.com.ar/qa/empresas/v2/login/ch/BP"), null);
            Pair responsePair = connector.genericPostWithResponseHeader((Object)request, LoginResponse.class, null, "", "application/json", "application/json");
            LoginResponse loginResponse = (LoginResponse)responsePair.getKey();
            log.info((Object)loginResponse);
            MultivaluedMap headers = (MultivaluedMap)responsePair.getValue();
            log.info((Object)"HEADERS");
            for (String headerName : headers.keySet()) {
                log.info((Object)(headerName + "=" + headers.get((Object)headerName)));
            }
            this.cache.put("accessToken", accessToken);
        }
        return accessToken;
    }
}

