package ar.com.sdd.patagoniaapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class MedioPago implements Serializable {

    @JsonProperty("descripcion")
    private String descripcion;

    @JsonProperty("importe")
    private String importe;

    @JsonProperty("porcentaje")
    private String porcentaje;

    @JsonProperty("cantidad")
    private String cantidad;

    @JsonProperty("moneda")
    private Moneda moneda;

    public String getDescripcion() {
        return descripcion;
    }

    public void setDescripcion(String descripcion) {
        this.descripcion = descripcion;
    }

    public String getImporte() {
        return importe;
    }

    public void setImporte(String importe) {
        this.importe = importe;
    }

    public String getPorcentaje() {
        return porcentaje;
    }

    public void setPorcentaje(String porcentaje) {
        this.porcentaje = porcentaje;
    }

    public String getCantidad() {
        return cantidad;
    }

    public void setCantidad(String cantidad) {
        this.cantidad = cantidad;
    }

    public Moneda getMoneda() {
        return moneda;
    }

    public void setMoneda(Moneda moneda) {
        this.moneda = moneda;
    }

    @Override
    public String toString() {
        return "MedioPago{" +
                "descripcion='" + descripcion + '\'' +
                ", importe='" + importe + '\'' +
                ", porcentaje='" + porcentaje + '\'' +
                ", cantidad='" + cantidad + '\'' +
                ", moneda=" + moneda +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        MedioPago that = (MedioPago) o;
        return Objects.equals(descripcion, that.descripcion) && Objects.equals(importe, that.importe) && Objects.equals(porcentaje, that.porcentaje) && Objects.equals(cantidad, that.cantidad) && Objects.equals(moneda, that.moneda);
    }

    @Override
    public int hashCode() {
        return Objects.hash(descripcion, importe, porcentaje, cantidad, moneda);
    }
}